<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}

$options = enginx_get_options();

//fields are hooked in inc/hooks.php
$title_reply = wp_kses_post( esc_html__('Leave a ', 'enginx' ) .  '<span>' . esc_html__( ' Comment', 'enginx') . '</span>' );
$req = get_option( 'require_name_email' );
$html_req = ( $req ? " required='required'" : '' );

$args = array(
	'comment_field'        => is_user_logged_in() ? '<p class="comment-form-comment form-group textarea has-placeholder"><label for="comment">' . esc_html_x( 'Comment', 'noun', 'enginx' ) . '</label><i class="fa fa-pencil"></i> <textarea id="comment"  class="form-control" name="comment" cols="45" rows="8"  aria-required="true" required="required"  placeholder="' . esc_attr__( 'Comment', 'enginx' ) . '"></textarea></p>' : '',
	'fields'               =>  array(
		'author'  => '<p class="comment-form-author form-group form-group has-placeholder">' . '<label for="author">' . esc_html__( 'Name', 'enginx' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label><i class="fa fa-user"></i> ' .
			'<input id="author" name="author" class="form-control" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" maxlength="245"' . $html_req . '   placeholder="' . esc_attr__( 'Enter your name', 'enginx' ) . '"/></p>',
		'email'   => '<p class="comment-form-email form-group has-placeholder"><label for="email">' . esc_html__( 'Email', 'enginx' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label><i class="fa fa-envelope"></i> ' .
			'<input id="email" name="email"  type="email" class="form-control"  value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" maxlength="100" ' . $html_req . '   placeholder="' . esc_attr__( 'Enter your mail', 'enginx' ) . '" /></p>',
		'comment_field'        => '<p class="comment-form-comment form-group textarea has-placeholder"><label for="comment">' . esc_html_x( 'Comment', 'noun', 'enginx' ) . '</label><i class="fa fa-pencil"></i><textarea id="comment"  class="form-control" name="comment" cols="45" rows="3"  aria-required="true" required="required"  placeholder="' . esc_attr__( 'Enter your message', 'enginx' ) . '"></textarea></p>',
	),

	'logged_in_as'         => '<p class="logged-in-as">' .
		sprintf(
			esc_html__( 'Logged in as ', 'enginx' ) . '<a href="%1$s" aria-label="%2$s">%3$s' .  '</a>. <a href="%4$s">' . esc_html__( 'Log out?', 'enginx' ) . '</a>',
			get_edit_user_link(),
			/* translators: %s: user name */
			esc_attr( sprintf( esc_html__( 'Logged in as %s. Edit your profile.', 'enginx' ), $user_identity ) ),
			$user_identity,
			wp_logout_url( apply_filters( 'the_permalink', get_permalink( get_the_ID() ) ) )
		) . '</p>',
	'comment_notes_before' => '',
	'class_form'           => 'comment-form',
	'cancel_reply_link'    => esc_html__( 'Cancel reply', 'enginx' ),
	'label_submit'         => esc_html__( 'Leave Comment', 'enginx' ),
	'title_reply'          => $title_reply,
	'title_reply_before'   => '<div class=" ' . esc_attr( $options['version'] ) . '"><h4 class="comments-title d-none fw-700 special-heading"><span>',
	'title_reply_after'    => '</span></h4>',
	'submit_button'        => '<button name="%1$s" type="submit" id="%2$s" class="btn btn-maincolor2 btn-small %3$s">%4$s</button>',
	'submit_field'         => '<p class="form-submit">%1$s %2$s</p>',
	'format'               => 'html5',
);
add_action( 'comment_form_after', 'enginx_echo_closing_div' );

?>

<div id="comments" class="comments-area">
	<h3 class="comments-title fw-700 special-heading <?php echo ( (wp_kses_post($args['title_reply']) == 'No comments') ? 'mb-0' : '') ?>">
		<span class="underline"><?php echo(wp_kses_post($args['title_reply'])) ?></span>
	</h3>
	 <div class="comment-respond  <?php echo esc_attr( $options['version'] ); ?>">
	<?php comment_form( $args ); ?>
	 </div>
	<?php if ( have_comments() ) : ?>
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<nav id="comment-nav-above" class="nav-links" role="navigation">
				<?php paginate_comments_links( array(
					'prev_text' => '<i class="fa fa-chevron-left"></i>',
					'next_text' => '<i class="fa fa-chevron-right"></i>',
				) ); ?>
			</nav><!-- #comment-nav-above -->
		<?php endif; // Check for comment navigation. ?>

		<ol class="comment-list">
			<?php
			wp_list_comments( array(
				'walker'      => enginx_return_comments_walker(),
				'style'       => 'ol',
				'short_ping'  => true,
				'avatar_size' => 80,
			) );
			?>
		</ol><!-- .comment-list -->
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<nav id="comment-nav-below" class="nav-links" role="navigation">
				<?php paginate_comments_links( array(
						'prev_text' => '<i class="fa fa-chevron-left"></i>',
						'next_text' => '<i class="fa fa-chevron-right"></i>',
					)
				); ?>
			</nav><!-- #comment-nav-below -->
		<?php endif; // Check for comment navigation. ?>

		<?php if ( ! comments_open() ) : ?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'enginx' ); ?></p>
		<?php endif; //comments_open() ?>

	<?php endif; // have_comments() ?>
</div><!-- #comments -->