<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'tab_main_options' => array(
		'type' => 'tab',
		'title' => esc_html__('Main Options', 'enginx'),
		'options' => array(
			'column_align'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Text alignment in column', 'enginx' ),
				'desc'    => esc_html__( 'Select text alignment inside your column', 'enginx' ),
				'choices' => array(
					''            => esc_html__( 'Inherit', 'enginx' ),
					'text-left'   => esc_html__( 'Left', 'enginx' ),
					'text-center' => esc_html__( 'Center', 'enginx' ),
					'text-right'  => esc_html__( 'Right', 'enginx' ),
				),
			),
			'column_padding'   => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Column padding', 'enginx' ),
				'desc'    => esc_html__( 'Select optional internal column paddings', 'enginx' ),
				'choices' => array(
					''     => esc_html__( 'No padding', 'enginx' ),
					'p-10' => esc_html__( '10px', 'enginx' ),
					'p-15' => esc_html__( '15px', 'enginx' ),
					'p-20' => esc_html__( '20px', 'enginx' ),
					'p-30' => esc_html__( '30px', 'enginx' ),
					'p-40' => esc_html__( '40px', 'enginx' ),
					'p-50' => esc_html__( '50px', 'enginx' ),
					'p-60' => esc_html__( '60px', 'enginx' ),

				),
			),
			'background_color' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Background color', 'enginx' ),
				'desc'    => esc_html__( 'Select background color', 'enginx' ),
				'help'    => esc_html__( 'Select one of predefined background types', 'enginx' ),
				'choices' => enginx_unyson_option_get_backgrounds_array(),
			),
			'column_animation' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Animation type', 'enginx' ),
				'desc'    => esc_html__( 'Select one of predefined animations', 'enginx' ),
				'choices' => enginx_unyson_option_animations(),
			),
			'column_additional_class' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Additional CSS class', 'enginx' ),
				'desc'  => esc_html__( 'Add your custom CSS class to column. Useful for Customization', 'enginx' ),
			),
		),
	),
	'tab_responsive' => array(
		'type' => 'tab',
		'title' => esc_html__('Responsive', 'enginx'),
		'options' => array(
			'responsive_alignment' => array(
				'type' => 'tab',
				'title' => esc_html__('Alignment', 'enginx'),
				'options' => array(
					'text_align_sm' => array(
						'type'    => 'select',
						'value'   => '',
						'label'   => esc_html__( 'Text align above 576px screen', 'enginx' ),
						'choices' => array(
							''   => esc_html__( 'Inherit', 'enginx' ),
							'text-sm-left'   => esc_html__( 'Left', 'enginx' ),
							'text-sm-center' => esc_html__( 'Center', 'enginx' ),
							'text-sm-right'  => esc_html__( 'Right', 'enginx' ),
						),
					),
					'text_align_md' => array(
						'type'    => 'select',
						'value'   => '',
						'label'   => esc_html__( 'Text align above 768px screen', 'enginx' ),
						'choices' => array(
							''   => esc_html__( 'Inherit', 'enginx' ),
							'text-md-left'   => esc_html__( 'Left', 'enginx' ),
							'text-md-center' => esc_html__( 'Center', 'enginx' ),
							'text-md-right'  => esc_html__( 'Right', 'enginx' ),
						),
					),
					'text_align_lg' => array(
						'type'    => 'select',
						'value'   => '',
						'label'   => esc_html__( 'Text align above 992px screen', 'enginx' ),
						'choices' => array(
							''   => esc_html__( 'Inherit', 'enginx' ),
							'text-lg-left'   => esc_html__( 'Left', 'enginx' ),
							'text-lg-center' => esc_html__( 'Center', 'enginx' ),
							'text-lg-right'  => esc_html__( 'Right', 'enginx' ),
						),
					),
					'text_align_xl' => array(
						'type'    => 'select',
						'value'   => '',
						'label'   => esc_html__( 'Text align above 1200px screen', 'enginx' ),
						'choices' => array(
							''   => esc_html__( 'Inherit', 'enginx' ),
							'text-xl-left'   => esc_html__( 'Left', 'enginx' ),
							'text-xl-center' => esc_html__( 'Center', 'enginx' ),
							'text-xl-right'  => esc_html__( 'Right', 'enginx' ),
						),
					),
				),
			),
			'responsive_visibility' => array(
				'type' => 'tab',
				'title' => esc_html__('Visibility', 'enginx'),
				'options' => enginx_unyson_option_responsive_options_array(),
			),
		),
	),
);
