<?php

//Main theme options class
class Enginx_Options {
	public $self;
	public $customizer_options;
	public $default_fonts_array;

	public function __construct() {

		//singleton
		if( $this->self ) {
			return $this->self;
		} else {
			$this->self = $this;
		}

		//set default fonts property
		$this->default_fonts_array = $this->set_default_fonts_array();

		//all customizer options here
		//default values needs for theme without unyson istalled
		$default_options = $this->get_default_options_array();
		$customizer_options = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option() : array();

		//additional option array keys that we are using in theme for check
		//if Unyson installed
		$customizer_options['fw'] = defined( 'FW' ) ? true : false;
		//if WooCommerce installed
		$customizer_options['woo'] = class_exists( 'WooCommerce' ) ? true : false;

		//customizer options overwriting default options
		$this->customizer_options = wp_parse_args( $customizer_options, $default_options );
	}

	//get option value from whole options array
	public function get_customizer_option( $option_name, $default_value = '' ) {
		return ( !empty( $this->customizer_options[$option_name] ) ) ? $this->customizer_options[$option_name] : $default_value;
	}

	//theme default fonts for include
	public function set_default_fonts_array() {
		//put default google fonts here
		return array(
			'Poppins' => array(
				'google_font'    => true,
				'subset'         => 'latin-ext',
				'variation'      => '300',
				'variants'       => array( '100i','100','200','300','300i','400','400i','500','700','900' ),
				'family'         => 'Poppins',
				'style'          => false,
				'weight'         => false,
				'size'           => '16',
				'line-height'    => '24',
				'letter-spacing' => '0',
				'color'          => false,
			)
		);
	}

	//theme default configuration options
	public function get_default_options_array() {
		return array (
			'logo_image' =>
				array (
					'attachment_id' => '93',
					'url' => ENGINX_THEME_URI . '/img/modal-login-form.jpg',
				),
			'logo_text' => 'EnginX',
			'logo_image_breadcrumbs' =>
				array (
				),
			'page_header' => '1',
			'header_absolute' =>
				array (
					'enabled' => '',
					'yes' =>
						array (
							'header_absolute_background_color' => 'ds bs',
							'header_absolute_background_image' => '',
						),
				),
			'header_is_fluid' => true,
			'header_background_color' => 'ds ms',
			'header_background_image' =>
				array (
					'type' => 'custom',
					'custom' => '',
					'predefined' => '',
					'data' =>
						array (
							'icon' => '',
							'css' =>
								array (
								),
						),
				),
			'header_background_cover' => false,
			'header_parallax' => false,
			'header_background_overlay' => true,
			'header_background_gradientradial' => false,
			'header_border_top' => '',
			'header_border_bottom' => '',
			'header_section_class' => '',
			'header_section_id' => '',
			'topline_is_fluid' => false,
			'topline_background_color' => 'ds ms',
			'topline_background_image' => '',
			'topline_background_cover' => false,
			'topline_parallax' => false,
			'topline_background_overlay' => false,
			'topline_background_gradientradial' => false,
			'topline_border_top' => '',
			'topline_border_bottom' => 's-borderbottom-container',
			'topline_section_class' => '',
			'topline_section_id' => '',
			'toplogo_is_fluid' => false,
			'toplogo_background_color' => 'ds',
			'toplogo_background_image' => '',
			'toplogo_background_cover' => false,
			'toplogo_parallax' => false,
			'toplogo_background_overlay' => true,
			'toplogo_background_gradientradial' => false,
			'toplogo_border_top' => '',
			'toplogo_border_bottom' => '',
			'toplogo_section_class' => '',
			'toplogo_section_id' => '',
			'page_title' => '5',
			'hide_term_title' => true,
			'title_is_fluid' => false,
			'title_background_color' => 'ds',
			'title_top_padding' => 's-pt-120',
			'title_bottom_padding' => 's-pb-50',
			'title_background_image' =>
				array (
					'type' => 'custom',
					'custom' => '',
					'predefined' => '',
					'data' =>
						array (
							'icon' => '',
							'css' =>
								array (
								),
						),
				),
			'title_background_cover' => false,
			'title_parallax' => false,
			'title_background_overlay' => false,
			'title_background_gradientradial' => false,
			'title_border_top' => '',
			'title_border_bottom' => '',
			'title_section_class' => '',
			'title_section_id' => '',
			'page_footer' => '1',
			'footer_is_fluid' => false,
			'footer_background_color' => 'ds ms',
			'footer_top_padding' => 's-pt-15',
			'footer_bottom_padding' => 's-pb-0',
			'footer_columns_padding' => '',
			'footer_columns_vertical_margins' => '',
			'footer_background_image' => '',
			'footer_background_cover' => false,
			'footer_parallax' => false,
			'footer_background_overlay' => false,
			'footer_background_gradientradial' => false,
			'footer_border_top' => '',
			'footer_border_bottom' => '',
			'footer_is_align_vertical' => false,
			'footer_section_class' => '',
			'footer_section_id' => '',
			'page_copyright' => '1',
			'copyright_text' => '
			© Enginx 2019 All Rights Reserved',
			'copyright_is_fluid' => false,
			'copyright_background_color' => 'ds ms',
			'copyright_top_padding' => 's-pt-25',
			'copyright_bottom_padding' => 's-pb-25',
			'copyright_columns_padding' => '',
			'copyright_columns_vertical_margins' => '',
			'copyright_background_image' => '',
			'copyright_background_cover' => false,
			'copyright_parallax' => false,
			'copyright_background_overlay' => false,
			'copyright_background_gradientradial' => false,
			'copyright_border_top' => '',
			'copyright_border_bottom' => '',
			'copyright_is_align_vertical' => false,
			'copyright_section_class' => '',
			'copyright_section_id' => '',
			'body_font_picker_switch' =>
				array (
					'main_font_enabled' => '',
					'main_font_options' =>
						array (
							'main_font' =>
								array (
									'google_font' => true,
									'subset' => 'latin-ext',
									'variation' => 'regular',
									'family' => 'Roboto',
									'style' => false,
									'weight' => false,
									'size' => 14,
									'line-height' => 24,
									'letter-spacing' => 0,
									'color' => false,
								),
						),
				),
			'h_font_picker_switch' =>
				array (
					'h_font_enabled' => '',
					'h_font_options' =>
						array (
							'h_font' =>
								array (
									'google_font' => true,
									'subset' => 'latin-ext',
									'variation' => 'regular',
									'family' => 'Roboto',
									'style' => false,
									'weight' => false,
									'size' => false,
									'line-height' => false,
									'letter-spacing' => 0,
									'color' => false,
								),
						),
				),
			'meta_phone' => '+1 23 456 78 90',
			'meta_email' => 'info@candycar.com',
			'social_icons' =>
				array (
					0 =>
						array (
							'icon' => 'fa fa-dribbble',
							'icon_class' => '',
							'icon_url' => '#',
						),
				),
			'layout' =>
				array (
					'boxed' => '',
					'boxed_options' =>
						array (
							'body_background_image' => '',
							'body_cover' => '',
							'boxed_extra_margins' => '',
						),
				),
			'version' => 'ls',
			'color_scheme_number' => '',
			'accent_color_1' => '',
			'accent_color_2' => '',
			'accent_color_3' => '',
			'accent_color_4' => '',
			'accent_color_5' => '',
			'blog_slider_switch' =>
				array (
					'blog_slider_enabled' => '',
					'yes' =>
						array (
							'slider_id' => '0',
						),
				),
			'blog_posts_widget_switch' => '',
			'preloader' =>
				array (
					'preloader_type' => 'image',
					'css' =>
						array (
							'options' => 'css',
						),
					'image' =>
						array (
							'options' => 'image',
						),
					'image_custom' =>
						array (
							'options' => '',
						),
					'disabled' =>
						array (
							'options' => '',
						),
				),
			'preloader_custom_class' => '',
			'meta_address' => 'Waukesha, WI 53186',
			'copyright_text2' => 'Theme: Enginx',
			'copyright_logo' => '',
			'blog_layout' => '1',
			'logo_image_inverse' =>
				array (
					'attachment_id' => '93',
					'url' => ENGINX_THEME_URI . '/img/logo.png',
				),
			'share_facebook' => '1',
			'share_twitter' => '1',
			'share_google_plus' => '0',
			'share_pinterest' => '0',
			'share_linkedin' => '0',
			'share_tumblr' => '0',
			'share_reddit' => '0',
			'404_top_padding' => 's-pt-115',
			'404_bottom_padding' => 's-pb-60',
			'404_top_padding_lg' => 's-pt-lg-150',
			'404_bottom_padding_lg' => 's-pb-lg-130',
			'footer_top_padding_xl' => 's-pt-xl-95',
			'footer_bottom_padding_xl' => 's-pb-xl-90',
			'footer_particles' => false,
			'copyright_particles' => false,
			'copyright_top_padding_md' => 's-pt-md-30',
			'footer_top_padding_lg' => 's-pt-lg-55',
			'footer_bottom_padding_lg' => 's-pb-lg-40',
			'blog_hide_tags' => false,
			'share_telegram' => '1',
			'plan_color_1' => '',
			'accent_color_5' => '',
			'meta_image' =>
				array (
					'attachment_id' => '1780',
					'url' => ENGINX_THEME_URI . '/img/modal-login-form.jpg',
				),
			'header_show_all_menu_items' => false,
			'header_disable_affix_xl' => false,
			'header_disable_affix_xs' => false,
			'header_particles' => false,
			'topline_particles' => false,
			'toplogo_particles' => false,
			'title_particles' => false,
			'title_horizontal_padding' => '',
			'title_top_padding_sm' => '',
			'title_bottom_padding_sm' => '',
			'title_top_padding_md' => '',
			'title_bottom_padding_md' => '',
			'title_top_padding_lg' => 's-pt-lg-115',
			'title_bottom_padding_lg' => 's-pb-lg-60',
			'title_top_padding_xl' => '',
			'title_bottom_padding_xl' => '',
			'footer_horizontal_padding' => '',
			'footer_top_padding_sm' => '',
			'footer_bottom_padding_sm' => '',
			'footer_top_padding_md' => '',
			'footer_bottom_padding_md' => '',
			'copyright_horizontal_padding' => '',
			'copyright_top_padding_sm' => '',
			'copyright_bottom_padding_sm' => '',
			'copyright_bottom_padding_md' => '',
			'copyright_top_padding_lg' => '',
			'copyright_bottom_padding_lg' => '',
			'copyright_top_padding_xl' => '',
			'copyright_bottom_padding_xl' => '',
			'404_is_fluid' => false,
			'404_background_color' => 'ls',
			'404_background_image' => '',
			'404_particles' => false,
			'404_background_cover' => false,
			'404_parallax' => false,
			'404_background_overlay' => false,
			'404_background_gradientradial' => false,
			'404_border_top' => '',
			'404_border_bottom' => '',
			'404_section_class' => '',
			'404_section_id' => '',
			'404_horizontal_padding' => '',
			'404_top_padding_sm' => '',
			'404_bottom_padding_sm' => '',
			'404_top_padding_md' => '',
			'404_bottom_padding_md' => '',
			'404_top_padding_xl' => '',
			'404_bottom_padding_xl' => '',
			'meta_image_width' => '410',
			'meta_image_height' => '598',
			'meta_buttons' =>
				array (
					0 =>
						array (
							'label' => 'Submit',
							'link' => '#',
							'target' => '_self',
							'color' => 'btn btn-maincolor',
							'size' => 'btn-small',
						),
				),
			'toplogo_buttons' =>
				array (
					0 =>
						array (
							'label' => 'Schedule Maintenance',
							'link' => '//localhost:3000/enginx/appointment/',
							'target' => '_self',
							'color' => 'btn btn-outline-maincolor',
							'size' => 'btn-small',
						),
				),
			'blog_hide_categories' => false,
			'blog_hide_author' => false,
			'blog_hide_date' => false,
			'blog_hide_comments_link' => false,
			'blog_change_date' => false,
			'header_buttons' =>
				array (
					0 =>
						array (
							'label' => 'Schedule Maintenance',
							'link' => '//localhost:3000/enginx/appointment/',
							'target' => '_self',
							'color' => 'btn btn-outline-maincolor',
							'size' => 'btn-small',
						),
				),
		);
	}
}


///////////////////
//options helpers//
///////////////////
if ( !function_exists( 'enginx_get_options' ) ) :
	/**
	 * Get all theme options in one array
	 * @return array
	 */
	function enginx_get_options() {
		$options = new Enginx_Options();
		$options = $options->customizer_options;
		//check if unyson installed - push 'fw' key to true
		return $options;
	}
endif; //enginx_get_options

if ( !function_exists( 'enginx_get_option' ) ) :
	/**
	 * Get single option
	 * @param $option_name
	 * @param string $default_value
	 *
	 * @return mixed|string
	 */
	function enginx_get_option( $option_name, $default_value = '' ) {
		// $option_value = function_exists( 'fw_get_db_customizer_option' ) ? fw_get_db_customizer_option( $option_name ) : $default_value;
		$options = new Enginx_Options();
		$option_value = $options->get_customizer_option( $option_name, $default_value );
		return $option_value;
	}
endif; //enginx_get_option


if ( !function_exists( 'enginx_get_default_section_option_value' ) ) :
	/**
	 * Get default section option value for customizer options
	 * used in enginx_get_section_options_array
	 * @param string $option_name
	 * @param string $default_value
	 *
	 * @return mixed|string
	 */
	function enginx_get_default_section_option_value( $option_name, $default_value = '' ) {
		$options_class = new Enginx_Options();
		$defaults = $options_class->get_default_options_array();
		$option_value = ( !empty ( $defaults[$option_name] ) ) ? $defaults[$option_name] : $default_value;
		return $option_value;
	}
endif; //enginx_get_default_section_option_value

if ( !function_exists( 'enginx_get_switch_option_type' ) ) :
	function enginx_get_switch_option_type( $switch_array, $option_name, $value = false ) {
		$value = enginx_get_default_section_option_value( $option_name, $value );

		return array_merge($switch_array, array(
			'value' => $value,
			'left-choice' => array(
				'value' => false,
				'label' => esc_html__('No', 'enginx'),
				'color' => '', // #HEX
			),
			'right-choice' => array(
				'value' => true,
				'label' => esc_html__('Yes', 'enginx'),
				'color' => '', // #HEX
			),
		) );
	}
endif; //enginx_get_switch_option_type

//section options array for any section
if ( !function_exists( 'enginx_get_section_options_array' ) ) :
	/**
	 * Get any section options
	 * @param string $prefix
	 * @param array $excluded_keys
	 *
	 * @return array
	 */
	function enginx_get_section_options_array( $prefix = '', $excluded_keys = array() ) {

		$options = array(
			$prefix . 'is_fluid' => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Full Width', 'enginx' ),
				'type'  => 'switch',
			), $prefix . 'is_fluid'
			),
			$prefix . 'background_color' => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value( $prefix . 'background_color', 'ls' ),
				'label'   => esc_html__( 'Background color', 'enginx' ),
				'help'    => esc_html__( 'Select one of predefined background colors',
					'enginx' ),
				'choices' => array(
					'ls'     => esc_html__( 'Light', 'enginx' ),
					'ls ms'  => esc_html__( 'Light Grey', 'enginx' ),
					'ds'     => esc_html__( 'Dark Color', 'enginx' ),
					'ds ds2'     => esc_html__( 'Dark Color 2', 'enginx' ),
					'ds ms'  => esc_html__( 'Dark Grey', 'enginx' ),
					'ds bs'  => esc_html__( 'Dark Blue', 'enginx' ),
					'cs'     => esc_html__( 'Main color', 'enginx' ),
					'cs cs2' => esc_html__( 'Main color 2', 'enginx' ),
				),
			),

			//100 80 60 50 30 25 20 15 10 5 2 1 0
			$prefix . 'columns_padding'  => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value($prefix . 'columns_padding', '' ),
				'label'   => esc_html__( 'Columns gutter (padding)', 'enginx' ),
				'help'    => esc_html__( 'Choose columns horizontal padding value (gutter)',
					'enginx' ),
				'choices' => array(
					'' => esc_html__( 'Inherited - default', 'enginx' ),
					'c-gutter-0'  => esc_html__( '0', 'enginx' ),
					'c-gutter-1'  => esc_html__( '1px', 'enginx' ),
					'c-gutter-2'  => esc_html__( '2px', 'enginx' ),
					'c-gutter-5'  => esc_html__( '5px', 'enginx' ),
					'c-gutter-10' => esc_html__( '10px', 'enginx' ),
					'c-gutter-20' => esc_html__( '20px', 'enginx' ),
					'c-gutter-25' => esc_html__( '25px', 'enginx' ),
					'c-gutter-30' => esc_html__( '30px', 'enginx' ),
					'c-gutter-50' => esc_html__( '50px', 'enginx' ),
					'c-gutter-60' => esc_html__( '60px', 'enginx' ),
					'c-gutter-70' => esc_html__( '70px', 'enginx' ),
					'c-gutter-80' => esc_html__( '80px', 'enginx' ),
					'c-gutter-100' => esc_html__( '100px', 'enginx' ),
				),
			),
			//0 1 2 5 10 15 20 25 30 40 50 60
			$prefix . 'columns_vertical_margins'  => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value( $prefix . 'columns_vertical_margins', '' ),
				'label'   => esc_html__( 'Column vertical margins', 'enginx' ),
				'help'    => esc_html__( 'Choose columns vertical margins value',
					'enginx' ),
				'choices' => array(
					''  => esc_html__( 'Top and bottom: 0 - default ', 'enginx' ),
					'c-my-1'  => esc_html__( 'Top and bottom: 1px', 'enginx' ),
					'c-my-2'  => esc_html__( 'Top and bottom: 2px', 'enginx' ),
					'c-my-5'  => esc_html__( 'Top and bottom: 5px', 'enginx' ),
					'c-my-10' => esc_html__( 'Top and bottom: 10px', 'enginx' ),
					'c-my-15' => esc_html__( 'Top and bottom: 15px', 'enginx' ),
					'c-my-20' => esc_html__( 'Top and bottom: 20px', 'enginx' ),
					'c-my-25' => esc_html__( 'Top and bottom: 25px', 'enginx' ),
					'c-my-30' => esc_html__( 'Top and bottom: 30px', 'enginx' ),
					'c-my-40' => esc_html__( 'Top and bottom: 40px', 'enginx' ),
					'c-my-50' => esc_html__( 'Top and bottom: 50px', 'enginx' ),
					'c-my-60' => esc_html__( 'Top and bottom: 60px', 'enginx' ),
					'c-mb-1'  => esc_html__( 'Bottom: 1px', 'enginx' ),
					'c-mb-2'  => esc_html__( 'Bottom: 2px', 'enginx' ),
					'c-mb-5'  => esc_html__( 'Bottom: 5px', 'enginx' ),
					'c-mb-10' => esc_html__( 'Bottom: 10px', 'enginx' ),
					'c-mb-15' => esc_html__( 'Bottom: 15px', 'enginx' ),
					'c-mb-20' => esc_html__( 'Bottom: 20px', 'enginx' ),
					'c-mb-25' => esc_html__( 'Bottom: 25px', 'enginx' ),
					'c-mb-30' => esc_html__( 'Bottom: 30px', 'enginx' ),
					'c-mb-40' => esc_html__( 'Bottom: 40px', 'enginx' ),
					'c-mb-50' => esc_html__( 'Bottom: 50px', 'enginx' ),
					'c-mb-60' => esc_html__( 'Bottom: 60px', 'enginx' ),
					'c-mt-1'  => esc_html__( 'Top: 1px', 'enginx' ),
					'c-mt-2'  => esc_html__( 'Top: 2px', 'enginx' ),
					'c-mt-5'  => esc_html__( 'Top: 5px', 'enginx' ),
					'c-mt-10' => esc_html__( 'Top: 10px', 'enginx' ),
					'c-mt-15' => esc_html__( 'Top: 15px', 'enginx' ),
					'c-mt-20' => esc_html__( 'Top: 20px', 'enginx' ),
					'c-mt-25' => esc_html__( 'Top: 25px', 'enginx' ),
					'c-mt-30' => esc_html__( 'Top: 30px', 'enginx' ),
					'c-mt-40' => esc_html__( 'Top: 40px', 'enginx' ),
					'c-mt-50' => esc_html__( 'Top: 50px', 'enginx' ),
					'c-mt-60' => esc_html__( 'Top: 60px', 'enginx' ),
				),
			),

			$prefix . 'background_image' => array(
				'label'   => esc_html__( 'Background Image', 'enginx' ),
				'help'    => esc_html__( 'Choose the background image for section', 'enginx' ),
				'type'    => 'background-image',
				'choices' => array(//	in future may will set predefined images
				)
			),
			$prefix . 'particles' => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Particles', 'enginx' ),
				'desc'    => esc_html__( 'Select here if you want to add particles to your section', 'enginx' ),
				'help'    => esc_html__( '', 'enginx' ),
				'type'  => 'switch'
			),
				$prefix . 'particles'

			),
			$prefix . 'background_cover' => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Background Cover', 'enginx' ),
				'desc'    => esc_html__( 'Stretch the image', 'enginx' ),
				'help'    => esc_html__( 'Adds "background-size:cover" CSS rule', 'enginx' ),
				'type'  => 'switch'
			),
				$prefix . 'background_cover'

			),
			$prefix . 'parallax'  => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Parallax', 'enginx' ),
				'help'    => esc_html__( 'Adds background parallax effect on section background image', 'enginx' ),
				'type'  => 'switch',
			),
				$prefix . 'parallax'

			),
			$prefix . 'background_overlay' => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Background Color Overlay', 'enginx' ),
				'help'    => esc_html__( 'Adds semitransparent color overlay on section', 'enginx' ),
				'type'  => 'switch',
			),
				$prefix . 'background_overlay'

			),
			$prefix . 'background_gradientradial' => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Background Radial Overlay', 'enginx' ),
				'help'    => esc_html__( 'Adds semitransparent light radial overlay on section', 'enginx' ),
				'type'  => 'switch',
			),
				$prefix . 'background_gradientradial'
			),
			$prefix . 'border_top'      => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value( $prefix . 'border_top', '' ),
				'label'   => esc_html__( 'Top border', 'enginx' ),
				'desc'    => esc_html__( 'Will be hidden if overlay option is used','enginx' ),
				'help'    => esc_html__( 'Top border will be hidden if overlay option is used', 'enginx' ),
				'choices' => array(
					''   => esc_html__( 'None', 'enginx' ),
					's-bordertop'   => esc_html__( 'Full Width','enginx' ),
					's-bordertop-container'  => esc_html__( 'Container Width', 'enginx' ),
				),
			),
			$prefix . 'border_bottom'      => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value( $prefix . 'border_bottom' ,'' ),
				'label'   => esc_html__( 'Bottom border', 'enginx' ),
				'choices' => array(
					''   => esc_html__( 'None', 'enginx' ),
					's-borderbottom'   => esc_html__( 'Full Width','enginx' ),
					's-borderbottom-container'  => esc_html__( 'Container Width', 'enginx' ),
				),
			),
			$prefix . 'is_align_vertical'  => enginx_get_switch_option_type( array(
				'label' => esc_html__( 'Vertical align content', 'enginx' ),
				'help'  => esc_html__( 'Align columns content vertically on wide screens', 'enginx' ),
				'type'  => 'switch',
			),
				$prefix . 'is_align_vertical'

			),
			$prefix . 'section_class' => array(
				'type'  => 'text',
				'value' => enginx_get_default_section_option_value( $prefix . 'section_class', '' ),
				'label' => esc_html__( 'Additional CSS class', 'enginx' ),
				'desc'  => esc_html__( 'Add your custom CSS class to section. Useful for Customization', 'enginx' ),
			),
			$prefix . 'section_id' => array(
				'type'  => 'text',
				'value' => enginx_get_default_section_option_value( $prefix . 'section_id', '' ),
				'label' => esc_html__( 'ID attribute', 'enginx' ),
				'desc'  => esc_html__( 'Add ID attribute to section. Useful for single page menu', 'enginx' ),
			),
		);

		if ( $excluded_keys ) {
			foreach ( $excluded_keys as $key ) {
				unset( $options[$prefix . $key] );
			}
		}

		return $options;
	}
endif; //enginx_get_section_options_array

//prepare section HTML attributes
if ( !function_exists( 'enginx_get_section_options' ) ) :
	/**
	 * Prepare section HTML attributes
	 * @param array $options
	 * @param string $prefix
	 *
	 * @return array
	 */
	function enginx_get_section_options( $options, $prefix = '') {
		//$options values that contains CSS class
		$section_class_values = array(
			$prefix . 'particles'         => $prefix . 'particles',
			$prefix . 'background_color'         => $prefix . 'background_color',
			$prefix . 'horizontal_padding'       => $prefix . 'horizontal_padding',
			$prefix . 'top_padding'              => $prefix . 'top_padding',
			$prefix . 'bottom_padding'           => $prefix . 'bottom_padding',
			$prefix . 'columns_padding'          => $prefix . 'columns_padding',
			$prefix . 'columns_vertical_margins' => $prefix . 'columns_vertical_margins',
			$prefix . 'border_top'               => $prefix . 'border_top',
			$prefix . 'border_bottom'            => $prefix . 'border_bottom',
			$prefix . 'columns_vertical_margins' => $prefix . 'columns_vertical_margins',
			$prefix . 'section_class'            => $prefix . 'section_class',
			//responsive options
			$prefix . 'hidden_xs'                => $prefix . 'hidden_xs',
			$prefix . 'hidden_sm'                => $prefix . 'hidden_sm',
			$prefix . 'hidden_md'                => $prefix . 'hidden_md',
			$prefix . 'hidden_lg'                => $prefix . 'hidden_lg',
			$prefix . 'hidden_xl'                => $prefix . 'hidden_xl',
			$prefix . 'top_padding_sm'           => $prefix . 'top_padding_sm',
			$prefix . 'bottom_padding_sm'        => $prefix . 'bottom_padding_sm',
			$prefix . 'top_padding_md'           => $prefix . 'top_padding_md',
			$prefix . 'bottom_padding_md'        => $prefix . 'bottom_padding_md',
			$prefix . 'top_padding_lg'           => $prefix . 'top_padding_lg',
			$prefix . 'bottom_padding_lg'        => $prefix . 'bottom_padding_lg',
			$prefix . 'top_padding_xl'           => $prefix . 'top_padding_xl',
			$prefix . 'bottom_padding_xl'        => $prefix . 'bottom_padding_xl',
		);

		//array with section attributes
		$array = array(
			'section_class' => '',
			'section_container_class_suffix' => '',
			'section_row_class_suffix' => '',
			'section_id' => '',
			'section_background_image' => '',
		);

		//skip top border if color overlay or radial gradient is active
		if( !empty( $options[$prefix . 'background_overlay'] ) || !empty( $options[$prefix . 'background_gradientradial'] ) ) {
			unset( $section_class_values[$prefix . 'border_top'] );
		}

		//if background is set for absolute header - making topline, toplogo, header and title section with same background
		if(
			( $prefix === 'topline_' || $prefix === 'toplogo_' || $prefix === 'header_' || $prefix === 'title_' )
			&&
			( !empty( $options['header_absolute']['enabled'] ) )
		)

		//if is page and Unyson is installed - overriding global header and footer options from page settings
		if	( is_page() )  {
			if( $prefix === 'header_' && function_exists( 'fw_get_db_post_option' ) ) {
				$page_options = fw_get_db_post_option( get_the_ID(), 'header_page' );
				if ( ! empty( $page_options['header_page_styles'] ) ) {
					$options = array_merge( $options, $page_options['header_page_custom_styles'] );
				}
			}
			if( $prefix === 'footer_' && function_exists( 'fw_get_db_post_option' ) ) {
				$page_options = fw_get_db_post_option( get_the_ID(), 'footer_page' );
				if ( ! empty( $page_options['footer_page_styles'] ) ) {
					$options = array_merge( $options, $page_options['footer_page_custom_styles'] );
				}
			}
		}

		//building CSS class
		foreach ( $options as $key => $value ) {
			if( in_array( $key, $section_class_values ) ) {
				$array['section_class'] .= ' ' . $value;
			}
		}

		//additional CSS classes
		$array['section_class'] .= ( !empty( $options[$prefix . 'parallax'] ) ) ? ' s-parallax' : '';
		$array['section_class'] .= ( !empty( $options[$prefix . 'background_cover'] ) ) ? ' cover-background' : '';
		$array['section_class'] .= ( !empty( $options[$prefix . 'particles'] ) ) ? ' with-particles' : '';
		$array['section_class'] .= ( !empty( $options[$prefix . 'background_overlay'] ) ) ? ' s-overlay' : '';
		$array['section_class'] .= ( !empty( $options[$prefix . 'background_gradientradial'] ) ) ? ' gradientradial-background' : '';

		//container CSS class
		$array['section_container_class_suffix'] .= ( !empty( $options[$prefix . 'is_fluid'] ) ) ? '-fluid' : '';

		//row CSS class
		$array['section_row_class_suffix'] .= ( !empty( $options[$prefix . 'is_align_vertical'] ) ) ? ' align-items-center' : '';

		//ID attribute
		$array['section_id'] .= ( !empty( $options[$prefix . 'section_id'] ) ) ? $options[$prefix . 'section_id'] : '';

		//bg image
		if ( !empty( $options[$prefix . 'background_image'] ) && !empty( $options[$prefix . 'background_image']['data']['icon'] ) ) {
			$array['section_background_image'] = 'background-image:url(' . $options[$prefix . 'background_image']['data']['icon'] . ');';
		}

		return $array;
	}
endif; //enginx_get_section_options


//default padding values that are set in variables_template SCSS file
if ( !function_exists( 'enginx_unyson_option_section_padding_choices ' ) ) :
	function enginx_unyson_option_section_padding_choices ( $prefix = '' ) {
		//see _variables_template.scss
		$padding_values = array( 0, 5, 10, 15, 20, 25, 30, 40, 50, 55, 60, 70, 75, 80, 85, 90, 95, 100, 115, 120, 130, 140, 145, 150);
		$breakpoins = array('xs', 'sm', 'md', 'lg', 'xl');

		$array = array( '' => esc_html__( 'Inherit', 'enginx' ) );
		foreach ( $padding_values as $value ) {
			$array[ $prefix . $value ] = esc_html__( $value . 'px', 'enginx' );
		}
		return $array;
	}
endif; //enginx_unyson_option_section_padding_choices


//section paddings


//background options
if ( !function_exists( 'enginx_unyson_option_get_section_padding_array' ) ) :
	function enginx_unyson_option_get_section_padding_array( $prefix = '' ) {
		return array(
			$prefix . 'horizontal_padding'      => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value($prefix . 'horizontal_padding', '' ),
				'label'   => esc_html__( 'Horizontal padding', 'enginx' ),
				'help'    => esc_html__( 'Choose horizontal padding value for section',
					'enginx' ),
				'choices' => array(
					' '                => esc_html__( 'Default', 'enginx' ),
					'container-px-0'   => esc_html__( 'None', 'enginx' ),
				),
			),
			//see _variables_template.scss
			//0 1 2 3 5 10 15 20 25 30 50 60 75 100 130
			$prefix . 'top_padding'      => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value($prefix . 'top_padding', 's-pt-50' ),
				'label'   => esc_html__( 'Top padding', 'enginx' ),
				'help'    => esc_html__( 'Choose top padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pt-' ),
			),
			$prefix . 'bottom_padding'   => array(
				'type'    => 'select',
				'value'   => enginx_get_default_section_option_value( $prefix . 'bottom_padding', 's-pb-50' ),
				'label'   => esc_html__( 'Bottom padding', 'enginx' ),
				'help'    => esc_html__( 'Choose bottom padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pb-' ),
			),
			$prefix . 'top_padding_sm' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Top padding above 576px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose top padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pt-sm-' ),
			),
			$prefix . 'bottom_padding_sm' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Bottom padding above 576px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose bottom padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pb-sm-' ),
			),
			$prefix . 'top_padding_md' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Top padding above 768px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose top padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pt-md-' ),
			),
			$prefix . 'bottom_padding_md' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Bottom padding above 768px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose bottom padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pb-md-' ),
			),
			$prefix . 'top_padding_lg' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Top padding above 992px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose top padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pt-lg-' ),
			),
			$prefix . 'bottom_padding_lg' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Bottom padding above 992px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose bottom padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pb-lg-' ),
			),
			$prefix . 'top_padding_xl' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Top padding above 1200px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose top padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pt-xl-' ),
			),
			$prefix . 'bottom_padding_xl' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Bottom padding above 1200px screen', 'enginx' ),
				'help'    => esc_html__( 'Choose bottom padding value for section',
					'enginx' ),
				'choices' => enginx_unyson_option_section_padding_choices( 's-pb-xl-' ),
			),
		);
	}
endif; //enginx_unyson_option_get_section_padding_array



//animations
if ( !function_exists( 'enginx_unyson_option_animations' ) ) :
	function enginx_unyson_option_animations() {
		return array(
			''               => esc_html__( 'None', 'enginx' ),
			'slideDown'      => esc_html__( 'slideDown', 'enginx' ),
			'scaleAppear'    => esc_html__( 'scaleAppear', 'enginx' ),
			'fadeInLeft'     => esc_html__( 'fadeInLeft', 'enginx' ),
			'fadeInUp'       => esc_html__( 'fadeInUp', 'enginx' ),
			'fadeInRight'    => esc_html__( 'fadeInRight', 'enginx' ),
			'fadeInDown'     => esc_html__( 'fadeInDown', 'enginx' ),
			'fadeIn'         => esc_html__( 'fadeIn', 'enginx' ),
			'slideRight'     => esc_html__( 'slideRight', 'enginx' ),
			'slideUp'        => esc_html__( 'slideUp', 'enginx' ),
			'slideLeft'      => esc_html__( 'slideLeft', 'enginx' ),
			'expandUp'       => esc_html__( 'expandUp', 'enginx' ),
			'slideExpandUp'  => esc_html__( 'slideExpandUp', 'enginx' ),
			'expandOpen'     => esc_html__( 'expandOpen', 'enginx' ),
			'bigEntrance'    => esc_html__( 'bigEntrance', 'enginx' ),
			'hatch'          => esc_html__( 'hatch', 'enginx' ),
			'tossing'        => esc_html__( 'tossing', 'enginx' ),
			'pulse'          => esc_html__( 'pulse', 'enginx' ),
			'floating'       => esc_html__( 'floating', 'enginx' ),
			'bounce'         => esc_html__( 'bounce', 'enginx' ),
			'pullUp'         => esc_html__( 'pullUp', 'enginx' ),
			'pullDown'       => esc_html__( 'pullDown', 'enginx' ),
			'stretchLeft'    => esc_html__( 'stretchLeft', 'enginx' ),
			'stretchRight'   => esc_html__( 'stretchRight', 'enginx' ),
			'fadeInUpBig'    => esc_html__( 'fadeInUpBig', 'enginx' ),
			'fadeInDownBig'  => esc_html__( 'fadeInDownBig', 'enginx' ),
			'fadeInLeftBig'  => esc_html__( 'fadeInLeftBig', 'enginx' ),
			'fadeInRightBig' => esc_html__( 'fadeInRightBig', 'enginx' ),
			'slideInDown'    => esc_html__( 'slideInDown', 'enginx' ),
			'slideInLeft'    => esc_html__( 'slideInLeft', 'enginx' ),
			'slideInRight'   => esc_html__( 'slideInRight', 'enginx' ),
			'moveFromLeft'   => esc_html__( 'moveFromLeft', 'enginx' ),
			'moveFromRight'  => esc_html__( 'moveFromRight', 'enginx' ),
			'moveFromBottom' => esc_html__( 'moveFromBottom', 'enginx' ),
		);
	}
endif; //enginx_unyson_option_animations

//responsive options
if ( !function_exists( 'enginx_unyson_option_responsive_options_array' ) ) :
	function enginx_unyson_option_responsive_options_array() {
		return array(
			'hidden-xs' => array(
				'type'  => 'switch',
				'value' => '',
				'label' => esc_html__('Hide on Extra small screens (below 576px)', 'enginx'),
				'left-choice' => array(
					'value' => '',
					'label' => esc_html__('Show', 'enginx'),
				),
				'right-choice' => array(
					'value' => 'hidden-xs',
					'label' => esc_html__('Hide', 'enginx'),
				),
			),
			'hidden-sm' => array(
				'type'  => 'switch',
				'value' => '',
				'label' => esc_html__('Hide on Small screens (between 576px and 767px)', 'enginx'),
				'left-choice' => array(
					'value' => '',
					'label' => esc_html__('Show', 'enginx'),
				),
				'right-choice' => array(
					'value' => 'hidden-sm',
					'label' => esc_html__('Hide', 'enginx'),
				),
			),
			'hidden-md' => array(
				'type'  => 'switch',
				'value' => '',
				'label' => esc_html__('Hide on Medium screens (between 768px and 991px)', 'enginx'),
				'left-choice' => array(
					'value' => '',
					'label' => esc_html__('Show', 'enginx'),
				),
				'right-choice' => array(
					'value' => 'hidden-md',
					'label' => esc_html__('Hide', 'enginx'),
				),
			),
			'hidden-lg' => array(
				'type'  => 'switch',
				'value' => '',
				'label' => esc_html__('Hide on Large screens (between 992px and 1199px)', 'enginx'),
				'left-choice' => array(
					'value' => '',
					'label' => esc_html__('Show', 'enginx'),
				),
				'right-choice' => array(
					'value' => 'hidden-lg',
					'label' => esc_html__('Hide', 'enginx'),
				),
			),
			'hidden-xl' => array(
				'type'  => 'switch',
				'value' => '',
				'label' => esc_html__('Hide on Extra Large screens (above 1200px)', 'enginx'),
				'left-choice' => array(
					'value' => '',
					'label' => esc_html__('Show', 'enginx'),
				),
				'right-choice' => array(
					'value' => 'hidden-xl',
					'label' => esc_html__('Hide', 'enginx'),
				),
			),
		);
	}
endif; //enginx_unyson_option_responsive_options_array



//background options
if ( !function_exists( 'enginx_unyson_option_get_backgrounds_array' ) ) :
	function enginx_unyson_option_get_backgrounds_array() {
		return array(
			''         => esc_html__( 'Transparent (No Background)', 'enginx' ),
			'hero-bg'  => esc_html__( 'Grey Color', 'enginx' ),
			'ds ms'    => esc_html__( 'Dark Grey Color', 'enginx' ),
			'ds'       => esc_html__( 'Dark Color', 'enginx' ),
			'cs'       => esc_html__( 'Main Color', 'enginx' ),
			'cs cs2'   => esc_html__( 'Main color 2', 'enginx' ),
			'cs cs3'   => esc_html__( 'Main Color 3', 'enginx' ),
			'bordered' => esc_html__( 'Transparent background with border', 'enginx' ),
		);
	}
endif; //enginx_unyson_option_get_backgrounds_array



//get responsive CSS classes from options array
if ( !function_exists( 'enginx_unyson_options_get_responsive_css_classes' ) ) :
	function enginx_unyson_options_get_responsive_css_classes( $options ) {
		$css_class = '';
		$css_class .= ( !empty( $options['hidden_xs'] ) ) ? ' ' . $options['hidden_xs'] : '';
		$css_class .= ( !empty( $options['hidden_sm'] ) ) ? ' ' . $options['hidden_sm'] : '';
		$css_class .= ( !empty( $options['hidden_md'] ) ) ? ' ' . $options['hidden_md'] : '';
		$css_class .= ( !empty( $options['hidden_lg'] ) ) ? ' ' . $options['hidden_lg'] : '';
		$css_class .= ( !empty( $options['hidden_xl'] ) ) ? ' ' . $options['hidden_xl'] : '';
		return trim ( $css_class );
	}
endif; //enginx_unyson_options_get_responsive_css_classes


//get divider class
if ( !function_exists( 'enginx_unyson_options_get_divider_css_classes' ) ) :
	function enginx_unyson_options_get_divider_css_classes( $options ) {
		$css_class = '';
		$css_class .= ( $options['all'] !== '' ) ? ' divider-' . $options['all'] : '';
		$css_class .= ( $options['sm'] !== '' ) ? ' divider-sm-' . $options['sm'] : '';
		$css_class .= ( $options['md'] !== '' ) ? ' divider-md-' . $options['md'] : '';
		$css_class .= ( $options['lg'] !== '' ) ? ' divider-lg-' . $options['lg'] : '';
		$css_class .= ( $options['xl'] !== '' ) ? ' divider-xl-' . $options['xl'] : '';

		return trim ( $css_class );
	}
endif; //enginx_unyson_options_get_responsive_css_classes

//detecting is topline is visible
if ( !function_exists( 'enginx_topline_is_visible' ) ) :
	function enginx_topline_is_visible() {
		$header = enginx_get_option( 'page_header' );
		//array with headers where topline is not shown
		return ( ! in_array( $header, array( '1', '2' ) ) );
	}
endif; //enginx_topline_is_visible

//detecting is toplogo is visible
if ( !function_exists( 'enginx_toplogo_is_visible' ) ) :
	function enginx_toplogo_is_visible() {
		$header = enginx_get_option( 'page_header' );
		//array with headers where toplogo is not shown
		return ( ! in_array( $header, array( '1', '2' ) ) );
	}
endif; //enginx_toplogo_is_visible

//detecting is copyright secondary text option is visible
if ( !function_exists( 'enginx_copyright_secondary_text_is_visible' ) ) :
	function enginx_copyright_secondary_text_is_visible() {
		$copyright = enginx_get_option( 'page_copyright' );
		//array with copyright where secondary text is visible
		return ( in_array( $copyright, array( '2' ) ) );
	}
endif; //enginx_copyright_secondary_text_is_visible

//detecting is copyright logo option is visible
if ( !function_exists( 'enginx_copyright_logo_is_visible' ) ) :
	function enginx_copyright_logo_is_visible() {
		$copyright = enginx_get_option( 'page_copyright' );
		//array with copyright where copyright logo is visible
		return ( in_array( $copyright, array( '3' ) ) );
	}
endif; //enginx_copyright_logo_is_visible

//detecting if shared buttons section is visible
if ( !function_exists( 'enginx_shared_buttons_options_is_visible' ) ) :
	function enginx_shared_buttons_options_is_visible() {
		return function_exists( 'mwt_share_this' );
	}
endif; //enginx_shared_buttons_options_is_visible

//predefined headers array
if ( !function_exists( 'enginx_get_predefined_headers_array' ) ) :
	function enginx_get_predefined_headers_array() {
		return array(
			'1'  => esc_html__( 'Default - logo and menu', 'enginx' ),
			'2'  => esc_html__( 'Header with toplogo and icons', 'enginx' ),
			'3'  => esc_html__( 'Header with toplogo and info', 'enginx' ),
			'100' => esc_html__( 'Left push header', 'enginx' ),
			'101' => esc_html__( 'Left slide header', 'enginx' ),
			'102' => esc_html__( 'Right push header', 'enginx' ),
			'103' => esc_html__( 'Right slide header', 'enginx' ),
		);
	}
endif; //enginx_get_predefined_headers_array

//header options array for customizer and for page options
if ( !function_exists( 'enginx_get_header_options_array_for_customizer_and_page' ) ) :
	function enginx_get_header_options_array_for_customizer_and_page( $defaults ) {
		return array(
			'header_layout'           => array(
				'title'   => esc_html__( 'Header Layout', 'enginx' ),
				//type tab for page options
				'type' => 'tab',
				'options' => array(
					'page_header' => array(
						'type'    => 'select',
						'value'   => $defaults['page_header'],
						'label'   => esc_html__( 'Template Header', 'enginx' ),
						'desc'    => esc_html__( 'Select one of predefined theme headers', 'enginx' ),
						'help'    => esc_html__( 'You can select one of predefined theme headers', 'enginx' ),
						'choices' => enginx_get_predefined_headers_array(),
						'blank'   => false, // (optional) if true, image can be deselected
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'header_absolute' => array(
						'label' => false,
						'desc'  => false,
						'type'  => 'multi-picker',
						'picker' => array(
							'enabled' => array(
								'label' => esc_html__('Position Absolute', 'enginx'),
								'type'  => 'switch',
								'right-choice' => array(
									'value' => 'yes',
									'label' => esc_html__('Enabled', 'enginx')
								),
								'left-choice' => array(
									'value' => '',
									'label' => esc_html__('Disabled', 'enginx')
								),
								'desc'  => esc_html__( 'Make header transparent and positioned inside slider or title section', 'enginx' ),
								'help'  => esc_html__( 'Adds "position:absolute" CSS rule on header', 'enginx' ),
								'wp-customizer-args' => array(
									'active_callback' => '__return_true',
								),
							),

						),
						'choices' => array(
							'yes' => array(
								'header_absolute_background_color' => array(
									'type'    => 'select',
									'value'   => 'ls',
									'label'   => esc_html__( 'Background color', 'enginx' ),
									'desc'    => esc_html__( 'This value will override selected background for Header and Title sections', 'enginx' ),
									'help'    => esc_html__( 'Select one of predefined background colors',
										'enginx' ),
									'choices' => array(
										'ls'     => esc_html__( 'Light', 'enginx' ),
										'ls ms'  => esc_html__( 'Light Grey', 'enginx' ),
										'ds'     => esc_html__( 'Dark Grey', 'enginx' ),
										'ds ms'  => esc_html__( 'Dark Muted', 'enginx' ),
										'ds bs'  => esc_html__( 'Dark Blue', 'enginx' ),
										'cs'     => esc_html__( 'Main color', 'enginx' ),
										'cs cs2' => esc_html__( 'Second Main color', 'enginx' ),
									),
									'wp-customizer-args' => array(
										'active_callback' => '__return_true',
									),
								),
								'header_absolute_background_image' => array(
									'label'   => esc_html__( 'Background Image', 'enginx' ),
									'help'    => esc_html__( 'Choose the background image for section', 'enginx' ),
									'type'    => 'background-image',
									'choices' => array(//	in future may will set predefined images
									),
									'wp-customizer-args' => array(
										'active_callback' => '__return_true',
									),
								),
								'class'   => array(
									'type'  => 'text',
									'label' => esc_html__( 'Optional additional CSS class', 'enginx' ),
								),
							),
						),
					),
					'header_show_all_menu_items' => array(
						'type'    => 'switch',
						'value'   => false,
						'label'   => esc_html__( 'Always show all menu items', 'enginx' ),
						'desc'    => esc_html__( 'Prevent hiding menu items that do not feet in menu width to sub-menus', 'enginx' ),
						'help'    => esc_html__( 'This option will not work if header with centered logo layout used', 'enginx' ),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__( 'Yes', 'enginx' )
						),
						'left-choice'  => array(
							'value' => false,
							'label' => esc_html__( 'No', 'enginx' )
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'header_disable_affix_xl' => array(
						'type'    => 'switch',
						'value'   => false,
						'label'   => esc_html__( 'Prevent sticky header on wide screens', 'enginx' ),
						'desc'    => esc_html__( 'Prevent header to be fixed on wide screens', 'enginx' ),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__( 'Yes', 'enginx' )
						),
						'left-choice'  => array(
							'value' => false,
							'label' => esc_html__( 'No', 'enginx' )
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'header_disable_affix_xs' => array(
						'type'    => 'switch',
						'value'   => false,
						'label'   => esc_html__( 'Prevent sticky header on small screens', 'enginx' ),
						'desc'    => esc_html__( 'Prevent header to be fixed on small screens', 'enginx' ),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__( 'Yes', 'enginx' )
						),
						'left-choice'  => array(
							'value' => false,
							'label' => esc_html__( 'No', 'enginx' )
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
				),
			),
			'header_section_options'  => array(
				'title'   => esc_html__( 'Header Section Options', 'enginx' ),
				//type tab for page options
				'type' => 'tab',
				'options' => enginx_get_section_options_array( 'header_', array(
					'top_padding',
					'bottom_padding',
					'top_padding_sm',
					'bottom_padding_sm',
					'top_padding_md',
					'bottom_padding_md',
					'top_padding_lg',
					'bottom_padding_lg',
					'top_padding_xl',
					'bottom_padding_xl',
					'columns_padding',
					'columns_vertical_margins',
					'is_align_vertical',

				) ),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
		);
	}
endif; //enginx_get_header_options_array_for_customizer_and_page

//predefined footers array
if ( !function_exists( 'enginx_get_predefined_footers_array' ) ) :
	function enginx_get_predefined_footers_array() {
		return array(
			'1' => esc_html__( '4 columns footer', 'enginx' ),
			'2' => esc_html__( '3 columns footer', 'enginx' ),
			'3' => esc_html__( '2 columns footer', 'enginx' ),
			'4' => esc_html__( '1 column footer', 'enginx' ),
		);
	}
endif; //enginx_get_predefined_footers_array

//footer options array for customizer and for page options
if ( !function_exists( 'enginx_get_footer_options_array_for_customizer_and_page' ) ) :
	function enginx_get_footer_options_array_for_customizer_and_page( $defaults ) {
		return array(
			'footer_layout' => array(
				'title'                  => esc_html__( 'Footer Section Layout', 'enginx' ),
				//type tab for page options
				'type' => 'tab',
				'options'                => array(
					'page_footer' => array(
						'type'    => 'select',
						'value'   => $defaults['page_footer'],
						'label'   => esc_html__( 'Page footer', 'enginx' ),
						'desc'    => esc_html__( 'Select one of predefined page footers.', 'enginx' ),
						'help'    => esc_html__( 'You can select one of predefined theme footers', 'enginx' ),
						'choices' => enginx_get_predefined_footers_array(),
						'blank'   => false, // (optional) if true, image can be deselected
					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'footer_section_options' => array(
				'title'   => esc_html__( 'Footer Section Options', 'enginx' ),
				//type tab for page options
				'type' => 'tab',
				'options' => enginx_get_section_options_array( 'footer_' ),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'footer_section_padding' => array(
				'title'   => esc_html__( 'Footer Section Padding', 'enginx' ),
				//type tab for page options
				'type' => 'tab',
				'options' => enginx_unyson_option_get_section_padding_array( 'footer_'),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
		);
	}
endif; //enginx_get_footer_options_array_for_customizer_and_page


//categories list default markup
add_filter( 'enginx_get_the_terms_defaults', function ( $args ) {
	$args['before'] = '<span class="cat-links">';
	$args['after'] = '</span>';

	return $args;
} );

add_filter( 'enginx_get_comments_counter_defaults', function ( $args ) {

	$options = enginx_get_options();
	if ( ! empty( $options['blog_hide_comments_link'] ) ) {
		$args['print'] = false;
	}

	return $args;
} );

