<?php
/**
 * The default template for displaying quote content
 *
 * Used for both index/archive/.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail   = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;
$post_thumbnail        = get_the_post_thumbnail( get_the_ID() );
$additional_post_class = ( $post_thumbnail ) ? 'cover-image ds bs cover-image s-overlay' : '';
?>
<article
		id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding' . $additional_post_class ); ?>>
	<?php
	echo wp_kses_post( $post_thumbnail );
	?>
	<div class="item-content entry-content">

		<div class="entry-content">
			<?php
			the_content( esc_html__( 'More...', 'enginx' ) );
			if (function_exists('mwt_share_this')) {
				enginx_share_this();
			}


			?>
			<h6 class="small-title"><?php the_title();?></h6>
		</div><!-- .entry-content -->
	</div><!-- eof .item-content -->
</article><!-- #post-## -->