<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'social_icons' => array(
		'type'            => 'addable-box',
		'value'           => '',
		'label'           => esc_html__( 'Social Buttons', 'enginx' ),
		'desc'            => esc_html__( 'Optional social buttons', 'enginx' ),
		'template'        => '{{=icon}}',
		'box-options'     => array(
			'icon'       => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Social Icon', 'enginx' ),
				'set'   => 'social-icons',
			),
			'icon_class' => array(
				'type'        => 'select',
				'value'       => '',
				'label'       => esc_html__( 'Icon type', 'enginx' ),
				'desc'        => esc_html__( 'Select one of predefined social button types', 'enginx' ),
				'choices'     => array(
					''                                    => esc_html__( 'Default', 'enginx' ),
					'border-icon'                         => esc_html__( 'Simple Bordered Icon', 'enginx' ),
					'border-icon rounded-icon'            => esc_html__( 'Rounded Bordered Icon', 'enginx' ),
					'bg-icon'                             => esc_html__( 'Simple Background Icon', 'enginx' ),
					'bg-icon rounded-icon'                => esc_html__( 'Rounded Background Icon', 'enginx' ),
					'color-icon bg-icon'                  => esc_html__( 'Color Light Background Icon', 'enginx' ),
					'color-icon bg-icon rounded-icon'     => esc_html__( 'Color Light Background Rounded Icon', 'enginx' ),
					'color-icon'                          => esc_html__( 'Color Icon', 'enginx' ),
					'color-icon border-icon'              => esc_html__( 'Color Bordered Icon', 'enginx' ),
					'color-icon border-icon rounded-icon' => esc_html__( 'Rounded Color Bordered Icon', 'enginx' ),
					'color-bg-icon'                       => esc_html__( 'Color Background Icon', 'enginx' ),
					'color-bg-icon rounded-icon'          => esc_html__( 'Rounded Color Background Icon', 'enginx' ),

				),
				/**
				 * Allow save not existing choices
				 * Useful when you use the select to populate it dynamically from js
				 */
				'no-validate' => false,
			),
			'icon_url'   => array(
				'type'  => 'text',
				'value' => '#',
				'label' => esc_html__( 'Icon Link', 'enginx' ),
				'desc'  => esc_html__( 'Provide a URL to your icon', 'enginx' ),
			)
		),
		'limit'           => 0, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'enginx' ),
		'sortable'        => true,
	)
);