<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$portfolio = fw()->extensions->get( 'portfolio' );
if ( empty( $portfolio ) ) {
	return;
}
/**
 * @var array $atts
 * @var array $posts
 */

$unique_id = uniqid();

//get all terms for filter
$terms = get_terms( array( 'post_type ' => 'fw-portfolio-category' ) );


if ( count( $terms ) > 1 && $atts['show_filters'] ) { ?>
	<div class="filters isotope_filters-<?php echo esc_attr( $unique_id ); ?> text-center">
		<a href="#" data-filter="*" class="selected"><?php esc_html_e( 'All', 'enginx' ); ?></a>
		<?php
		foreach ( $terms as $term_key => $term_id ) {
			$current_term = get_term( $term_id, 'fw-portfolio-category' );
			?>
			<a href="#"
			   data-filter=".<?php echo esc_attr( $current_term->slug ); ?>"><?php echo esc_html( $current_term->name ); ?></a>
			<?php
		} //foreach
		?>
	</div>
	<?php
} //count subcategories check
?>

<div class="istotpe-wrapper isotope row masonry-layout c-gutter-0"
     data-filters=".isotope_filters-<?php echo esc_attr( $unique_id ); ?>">
    <?php while ( $posts->have_posts() ) : $posts->the_post();
        //get categories slugs for isotope filters
        $post_terms       = get_the_terms( get_the_ID(), 'fw-portfolio-category' );
        $post_terms_class = '';
        if ( ! empty ( $post_terms ) ) :
            foreach ( $post_terms as $post_term ) :
                $post_terms_class .= $post_term->slug . ' ';
            endforeach;
        endif;
        //get item size
        $column_class = 'col-lg-4';
        $post_thumbnail_size = 'enginx-portfolio-shortcode-tile-square';

        if ( ( $posts->current_post === 1 ) || ( $posts->current_post === 4 ) ) {
            $column_class = 'col-lg-8';
            $post_thumbnail_size = 'enginx-portfolio-shortcode-tile-half-square-horizontal';
        }
        ?>

        <div
            class="isotope-item <?php echo esc_attr( 'item-layout-tile col-sm-6' . ' ' . $column_class . ' ' . $post_terms_class ); ?>">
            <?php
            //include item layout view file
            if ( has_post_thumbnail() ) { ?>
                <div class="vertical-item gallery-item content-absolute text-center cs">
                    <div class="item-media">
                        <?php
                        $full_image_src = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
                        the_post_thumbnail( $post_thumbnail_size );
                        ?>
                        <div class="media-links">
                            <div class="links-wrap">
                                <a class="link-zoom photoswipe-link"
                                   href="<?php echo esc_attr( $full_image_src ); ?>"></a>
                            </div>
                        </div>
                    </div>
                    <div class="item-content">
                        <h4 class="item-meta">
                            <a href="<?php the_permalink(); ?>">
                                <?php the_title(); ?>
                            </a>
                        </h4>
                    </div>
                </div>
            <?php
            } else {
                include( fw()->extensions->get( 'portfolio' )->locate_view_path( 'item-extended' ) );
            }
            ?>
        </div>
    <?php endwhile; ?>
    <?php //removed reset the query ?>
</div><!-- eof .istotpe-wrapper -->
