<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'number'        => array(
		'type'       => 'slider',
		'value'      => 6,
		'properties' => array(
			'min'  => 1,
			'max'  => 12,
			'step' => 1,

		),
		'label'      => esc_html__( 'Items number', 'enginx' ),
		'desc'       => esc_html__( 'Number of posts to display', 'enginx' ),
	),
	'nav'           => array(
		'type'         => 'switch',
		'value'        => 'true',
		'label'        => esc_html__( 'Show Navigation', 'enginx' ),
		'left-choice'  => array(
			'value' => 'false',
			'label' => esc_html__( 'No', 'enginx' ),
		),
		'right-choice' => array(
			'value' => 'true',
			'label' => esc_html__( 'Yes', 'enginx' ),
		),
	),
	'margin'        => array(
		'label'   => esc_html__( 'Horizontal item margin (px)', 'enginx' ),
		'desc'    => esc_html__( 'Select horizontal item margin', 'enginx' ),
		'value'   => '30',
		'type'    => 'select',
		'choices' => array(
			'0'  => esc_html__( '0', 'enginx' ),
			'1'  => esc_html__( '1px', 'enginx' ),
			'2'  => esc_html__( '2px', 'enginx' ),
			'10' => esc_html__( '10px', 'enginx' ),
			'30' => esc_html__( '30px', 'enginx' ),
			'60' => esc_html__( '60px', 'enginx' )
		)
	),
	'layout'        => array(
		'label'   => esc_html__( 'Post Layout', 'enginx' ),
		'desc'    => esc_html__( 'Choose post layout', 'enginx' ),
		'value'   => 'carousel',
		'type'    => 'select',
		'choices' => array(
			'carousel' => esc_html__( 'Carousel', 'enginx' ),
			'isotope'  => esc_html__( 'Masonry Grid', 'enginx' ),
		)
	),
	'item_layout'   => array(
		'label'   => esc_html__( 'Item layout', 'enginx' ),
		'desc'    => esc_html__( 'Choose Item layout', 'enginx' ),
		'value'   => 'item-regular',
		'type'    => 'select',
		'choices' => array(
			'item-regular'  => esc_html__( 'Regular (just image)', 'enginx' ),
			'item-title'    => esc_html__( 'Image with title', 'enginx' ),
			'item-extended' => esc_html__( 'Image with title and excerpt', 'enginx' ),
		)
	),
	'responsive_lg' => array(
		'label'   => esc_html__( 'Columns on large screens', 'enginx' ),
		'desc'    => esc_html__( 'Select items number on wide screens (>1200px)', 'enginx' ),
		'value'   => '4',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'enginx' ),
			'2' => esc_html__( '2', 'enginx' ),
			'3' => esc_html__( '3', 'enginx' ),
			'4' => esc_html__( '4', 'enginx' ),
			'6' => esc_html__( '6', 'enginx' ),
		)
	),
	'responsive_md' => array(
		'label'   => esc_html__( 'Columns on middle screens', 'enginx' ),
		'desc'    => esc_html__( 'Select items number on middle screens (>992px)', 'enginx' ),
		'value'   => '3',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'enginx' ),
			'2' => esc_html__( '2', 'enginx' ),
			'3' => esc_html__( '3', 'enginx' ),
			'4' => esc_html__( '4', 'enginx' ),
			'6' => esc_html__( '6', 'enginx' ),
		)
	),
	'responsive_sm' => array(
		'label'   => esc_html__( 'Columns on small screens', 'enginx' ),
		'desc'    => esc_html__( 'Select items number on small screens (>768px)', 'enginx' ),
		'value'   => '2',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'enginx' ),
			'2' => esc_html__( '2', 'enginx' ),
			'3' => esc_html__( '3', 'enginx' ),
			'4' => esc_html__( '4', 'enginx' ),
			'6' => esc_html__( '6', 'enginx' ),
		)
	),
	'responsive_xs' => array(
		'label'   => esc_html__( 'Columns on extra small screens', 'enginx' ),
		'desc'    => esc_html__( 'Select items number on extra small screens (<767px)', 'enginx' ),
		'value'   => '1',
		'type'    => 'select',
		'choices' => array(
			'1' => esc_html__( '1', 'enginx' ),
			'2' => esc_html__( '2', 'enginx' ),
			'3' => esc_html__( '3', 'enginx' ),
			'4' => esc_html__( '4', 'enginx' ),
			'6' => esc_html__( '6', 'enginx' ),
		)
	),
	'show_filters'  => array(
		'type'         => 'switch',
		'value'        => false,
		'label'        => esc_html__( 'Show filters', 'enginx' ),
		'desc'         => esc_html__( 'Hide or show categories filters', 'enginx' ),
		'left-choice'  => array(
			'value' => false,
			'label' => esc_html__( 'No', 'enginx' ),
		),
		'right-choice' => array(
			'value' => true,
			'label' => esc_html__( 'Yes', 'enginx' ),
		),
	),
	'cat' => array(
		'type'  => 'multi-select',
		'label' => esc_html__('Select categories', 'enginx'),
		'desc'  => esc_html__('You can select one or more categories', 'enginx'),
		'population' => 'taxonomy',
		'source' => 'category',
		'prepopulate' => 10,
		'limit' => 100,
	)
);