<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * @var $atts
 */

if ( ! $atts['steps'] ) {
	return;
}
?>
<div class="row text-center fw-steps-wrap c-mb-53 c-mb-lg-0">
	<?php foreach ( $atts['steps'] as $step ) :
		$unique_id = uniqid();
		?>
	<div class="col-12 col-md-6 col-lg-3 fw-step-content <?php echo wp_kses_post( $step['featured'] ); ?>">
			<div class="fw-step-img">
				<div id="card-<?php echo esc_attr( $unique_id ); ?>">
					<?php
					$attachment_id = ! empty( $step['step_image']['attachment_id'] ) ? $step['step_image']['attachment_id'] : '';
					echo wp_get_attachment_image( $attachment_id,  $icon = false, $attr = '' ); ?>
				</div>
			</div>
				<?php
				if ( ! empty( $step['step_title'] ) ): ?>
					<h6 class="step-title"><?php echo wp_kses_post( $step['step_title'] ); ?></h6>
				<?php endif; ?>
			<?php if ( ! empty( $step['step_text'] ) ): ?>
				<div class="step-text color-dark">
					<p>
						<?php echo wp_kses_post( $step['step_text'] ); ?>
					</p>
				</div>
			<?php endif; ?>
		</div>
	<?php endforeach; ?>
</div>

