<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$id = uniqid( 'testimonials-' );

?>

<?php if ( ! empty( $atts['title'] ) ): ?>
    <h3 class="fw-testimonials-title text-center"><?php echo esc_html( $atts['title'] ); ?></h3>
<?php endif; ?>
<div class="testimonials-slider owl-carousel"
     data-autoplay="false"
     data-loop="true"
     data-responsive-lg="1"
     data-responsive-md="1"
     data-responsive-sm="1"
     data-nav="true"
     data-dots="false"
	 data-margin="0"
>
    <?php foreach ( $atts['testimonials'] as $testimonial ): ?>
    <blockquote class="quote-item">
        <div class="quote-image">
        <?php
        $author_image_url = ! empty( $testimonial['author_avatar']['url'] )
            ? $testimonial['author_avatar']['url']
            : fw_get_framework_directory_uri( '/static/img/no-image.png' );
        ?>
        <img src="<?php echo esc_attr( $author_image_url ); ?>"
             alt="<?php echo esc_attr( $testimonial['author_name'] ); ?>"/>
        </div>
		<div class="quote-mark">
			<?php if ( ! empty( $testimonial['quote_mark'] ) )  : ?>
				<img src="<?php echo esc_attr( $testimonial['quote_mark']['url'] ); ?>" alt="<?php echo esc_attr( the_title() ); ?>">
			<?php endif; ?>
		</div>
        <p class="big fw-300"><?php echo esc_html( $testimonial['content'] ); ?></p>
		<h6 class="fw-700 quote-name">
			<?php echo esc_html( $testimonial['author_name'] ); ?> <?php echo esc_html( $testimonial['author_job'] || $testimonial['site_name'] ) ? '' : ''; ?>
			<?php echo esc_html( $testimonial['author_job'] && $testimonial['site_name'] ) ? '' : ''; ?>
			<?php if ( $testimonial['site_url'] ) : ?>
			<a href="<?php echo esc_attr( $testimonial['site_url'] ); ?>">
				<?php endif; //site_url ?>
				<?php echo esc_html( $testimonial['site_name'] ); ?>
				<?php if ( $testimonial['site_url'] ) : ?>
			</a>
		<?php endif; //site_url ?>
		</h6>
		<p class="quote-position">
			<?php echo esc_html( $testimonial['author_job'] ); ?>
		</p>
    </blockquote>
    <?php endforeach; ?>
</div> <!-- .testimonials-slider.owl-carousel -->
