<?php if ( ! defined( 'ABSPATH' ) ) {
	die();
}
if ( ! defined( 'FW' ) ) {
	return;
}
/**
 * @var string $before_widget
 * @var string $after_widget
 * @var array $params
 */

//unyson theme shortcodes
$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
$icons_list  = array();
if ( ! empty( $shortcodes_extension ) ) {
	$shortcode_icons_list = $shortcodes_extension->get_shortcode( 'icons_list' );

}

$unique_id = uniqid();

echo wp_kses_post( $before_widget );

if ( ! empty ( $params[ 'title' ] ) ) :
	echo wp_kses_post( $before_title . $params[ 'title' ] . $after_title );
endif; //title

if ( ! empty ( $params['social_icons'] ) ) : ?>
	<p class="social-icons text-center">
		<?php foreach ( $params['social_icons'] as $icon ): ?>
			<?php if ( ! empty ( $icon['icon_class'] ) && ! empty ( $icon['icon_link'] )  ): ?>
				<span><a href="<?php echo esc_url( $icon['icon_link'] ); ?>" target="_blank" class="social-icon border-icon rounded-icon text-center <?php echo esc_attr( $icon['icon_class'] ); ?>"></a></span>
			<?php endif; //icon	?>
		<?php endforeach; ?>
	</p>
<?php endif; //social-icons

if ( ! empty( $params[ 'icons' ] ) && ( ! empty ( $shortcode_icons_list ) ) ) :
	echo wp_kses_post( $shortcode_icons_list->render( array( 'icons' => $params[ 'icons' ] ) ) );
endif; //icons list


echo wp_kses_post( $after_widget );