<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$button         = fw_ext( 'shortcodes' )->get_shortcode( 'button' );
$button_options = $button->get_options();
$button_options['button_animation'] = array(
	'type'    => 'select',
	'value'   => 'fadeIn',
	'label'   => esc_html__( 'Animation type', 'enginx' ),
	'desc'    => esc_html__( 'Select one of predefined animations', 'enginx' ),
	'choices' => enginx_unyson_option_animations(),
);

$events_box_options_event_options = array();
//if events extension is active and if our custom events extension class exists
if( class_exists( 'Enginx_Unyson_Events_Extends' ) && ( ! empty( fw_ext( 'events' ) ) ) ) {
	$events_box_options_event_options['next_event'] = array(
		'type'  => 'switch',
		'value' => false,
		'label' => esc_html__('Add next event counter below layer', 'enginx'),
		'left-choice' => array(
			'value' => false,
			'label' => esc_html__(' No', 'enginx'),
		),
		'right-choice' => array(
			'value' => true,
			'label' => esc_html__(' Yes', 'enginx'),
		),
	);
}

$options = array(
	'slide_background' => array(
		'type'        => 'select',
		'value'       => 'ls',
		'label'       => esc_html__( 'Slide background', 'enginx' ),
		'desc'        => esc_html__( 'Select slide background color', 'enginx' ),
		'choices'     => array(
			'ls'    => esc_html__( 'Light', 'enginx' ),
			'ls ms' => esc_html__( 'Light Muted', 'enginx' ),
			'ds'    => esc_html__( 'Dark', 'enginx' ),
			'ds ms' => esc_html__( 'Dark Muted', 'enginx' ),
			'cs'    => esc_html__( 'Color', 'enginx' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_align'      => array(
		'type'        => 'select',
		'value'       => 'text-left',
		'label'       => esc_html__( 'Slide text alignment', 'enginx' ),
		'desc'        => esc_html__( 'Select slide text alignment', 'enginx' ),
		'choices'     => array(
			'text-left'   => esc_html__( 'Left', 'enginx' ),
			'text-center' => esc_html__( 'Center', 'enginx' ),
			'text-right'  => esc_html__( 'Right', 'enginx' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_vertical_align'      => array(
		'type'        => 'select',
		'value'       => '',
		'label'       => esc_html__( 'Slide vertical alignment', 'enginx' ),
		'desc'        => esc_html__( 'Select vertcial alignment for slider layers', 'enginx' ),
		'choices'     => array(
			''   => esc_html__( 'Middle (default)', 'enginx' ),
			'intro_text_top' => esc_html__( 'Top', 'enginx' ),
			'intro_text_bottom'  => esc_html__( 'Bottom', 'enginx' ),
		),
		/**
		 * Allow save not existing choices
		 * Useful when you use the select to populate it dynamically from js
		 */
		'no-validate' => false,
	),
	'slide_layers'     => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Slide Layers', 'enginx' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'enginx' ),

		'box-options' => array_merge( array(
			'layer_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Layer tag', 'enginx' ),
				'desc'    => esc_html__( 'Select a tag for your ', 'enginx' ),
				'choices' => array(
					'h3' => esc_html__( 'H3 tag', 'enginx' ),
					'h2' => esc_html__( 'H2 tag', 'enginx' ),
					'h4' => esc_html__( 'H4 tag', 'enginx' ),
					'p'  => esc_html__( 'P tag', 'enginx' ),

				),
			),
			'layer_animation'      => array(
				'type'    => 'select',
				'value'   => 'fadeIn',
				'label'   => esc_html__( 'Animation type', 'enginx' ),
				'desc'    => esc_html__( 'Select one of predefined animations', 'enginx' ),
				'choices' => enginx_unyson_option_animations(),
			),
			'layer_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Layer text', 'enginx' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'enginx' ),
			),
			'layer_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text color', 'enginx' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'enginx' ),
				'choices' => array(
					''           => esc_html__( 'Inherited', 'enginx' ),
					'color-main'  => esc_html__( 'First theme main color', 'enginx' ),
					'color-main2' => esc_html__( 'Second theme main color', 'enginx' ),
					'color-darkgrey'       => esc_html__( 'Dark grey theme color', 'enginx' ),
					'color-dark'      => esc_html__( 'Dark theme color', 'enginx' ),

				),
			),
			'layer_text_weight'    => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text weight', 'enginx' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'enginx' ),
				'choices' => array(
					''     => esc_html__( 'Normal', 'enginx' ),
					'bold' => esc_html__( 'Bold', 'enginx' ),
					'thin' => esc_html__( 'Thin', 'enginx' ),

				),
			),
			'layer_text_transform' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Layer text transform', 'enginx' ),
				'desc'    => esc_html__( 'Select a text transformation for your layer', 'enginx' ),
				'choices' => array(
					''                => esc_html__( 'None', 'enginx' ),
					'text-lowercase'  => esc_html__( 'Lowercase', 'enginx' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'enginx' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'enginx' ),

				),
			),
			'class' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Additional Layer CSS class', 'enginx' ),
			), $events_box_options_event_options )
		),
		'template'    => esc_html__( 'Slider Layer', 'enginx' ),
		'limit'           => 5, // limit the number of boxes that can be added
		'add-button-text' => esc_html__( 'Add', 'enginx' ),
	),
	'class'           => array(
		'type'  => 'text',
		'value' => '',
		'label' => esc_html__( 'Additional Slide CSS class', 'enginx' ),
	),
	'button' => array(
		'type'    => 'multi-picker',
		'label'   => false,
		'desc'    => false,
		'value'   => false,
		'picker'  => array(
			'show_button' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Show button', 'enginx' ),
				'left-choice'  => array(
					'value' => '',
					'label' => esc_html__( 'No', 'enginx' ),
				),
				'right-choice' => array(
					'value' => 'button',
					'label' => esc_html__( 'Yes', 'enginx' ),
				),
			),
		),
		'choices' => array(
			''       => array(),
			'button' => $button_options,
		),
	),
);