<?php

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

//header products counter ajax refresh
add_filter( 'woocommerce_add_to_cart_fragments', 'enginx_woocommerce_cart_count_fragments', 10, 1 );
if ( ! function_exists( 'enginx_woocommerce_cart_count_fragments' ) ) :
function enginx_woocommerce_cart_count_fragments( $fragments ) {
	$fragments['span.cart-count'] = '<span class="badge bg-maincolor cart-count">';
	if (! empty( WC()->cart->get_cart_contents_count() ) ) {
		$fragments['span.cart-count'] .= WC()->cart->get_cart_contents_count();
	}
	$fragments['span.cart-count'] .= '</span>';
	return $fragments;
}
endif;

//remove page title in shop page
add_filter( 'woocommerce_show_page_title', 'enginx_filter_remove_shop_title_in_content' );
if ( ! function_exists( 'enginx_filter_remove_shop_title_in_content' ) ) :
	function enginx_filter_remove_shop_title_in_content() {
		return false;
	}
endif;

//remove wrappers
remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
remove_action( 'enginx_get_columns_classes', 'enginx_get_columns_classes', 10 );
remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );



//loop pagination
//closing main column and getting sidebar if exist
add_action( 'woocommerce_after_shop_loop', 'enginx_action_echo_div_columns_after_shop_loop' );
if ( ! function_exists( 'enginx_action_echo_div_columns_after_shop_loop' ) ):
	function enginx_action_echo_div_columns_after_shop_loop() {
		echo '</div><!-- eof #content_products -->';
		$column_classes = enginx_get_columns_classes();
		if ( $column_classes[ 'sidebar_class' ] ): ?>
			<!-- main aside sidebar -->
			<aside class="<?php echo esc_attr( $column_classes[ 'sidebar_class' ] ); ?>">
				<?php get_sidebar(); ?>
			</aside>
			<!-- eof main aside sidebar -->
			<?php
		endif;
	}
endif;


//start of loop item
add_action( 'woocommerce_before_shop_loop_item', 'enginx_action_echo_markup_before_shop_loop_item' );
if ( ! function_exists( 'enginx_action_echo_markup_before_shop_loop_item' ) ):
	function enginx_action_echo_markup_before_shop_loop_item() {
		echo '<div class="vertical-item padding-small product-inner bordered content-padding">';
		echo '<div class="item-media">';
		woocommerce_template_loop_product_link_open();

	}
endif;

add_action( 'woocommerce_before_shop_loop_item_title', 'enginx_action_echo_markup_before_shop_loop_item_title' );
if ( ! function_exists( 'enginx_action_echo_markup_before_shop_loop_item_title' ) ):
	function enginx_action_echo_markup_before_shop_loop_item_title() {
		woocommerce_template_loop_product_link_close();
		echo '</div> <!-- eof .item-media -->';
		echo '<div class="item-content">';
	}
endif;

add_action( 'woocommerce_before_shop_loop', 'enginx_action_echo_div_before_shop_loop' );
if ( ! function_exists( 'enginx_action_echo_div_before_shop_loop' ) ) :
	function enginx_action_echo_div_before_shop_loop() {
		$column_classes = enginx_get_columns_classes();
		echo '<div id="content_products" class="' . esc_attr( $column_classes[ 'main_column_class' ] ) . '">';
	}
endif;

remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'enginx_action_woocommerce_template_loop_product_title', 10 );
if ( ! function_exists( 'enginx_action_woocommerce_template_loop_product_title' ) ):
	function enginx_action_woocommerce_template_loop_product_title() {
		echo '<h2 class="woocommerce-loop-product__title">';
		woocommerce_template_loop_product_link_open();
		the_title();
		woocommerce_template_loop_product_link_close();
		echo '</h2>';
	}
endif;

//before shop loop - removing breadcrumbs and results count
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );

//wrapping sort form in div and adding view toggle button
add_action( 'woocommerce_before_shop_loop', 'enginx_action_before_shop_loop_wrap_form', 15 );
if ( ! function_exists( 'enginx_action_before_shop_loop_wrap_form' ) ) :
	function enginx_action_before_shop_loop_wrap_form() {
		echo '<div class="storefront-sorting clearfix form-inline shop-form bordered mb-30">';
		woocommerce_result_count();
		echo '<span class="d-flex align-items-center">';
		echo '<strong>';
		echo esc_html__( 'Sort By', 'enginx' );
		echo '</strong>';
		woocommerce_catalog_ordering();
		echo '</span>';
		echo '<span>';
		echo '<strong>';
		echo esc_html__( 'View', 'enginx' );
		echo '</strong>';
		echo '<a href="#" id="toggle_shop_view" class=""></a></span>';
		echo '</div>';
		}
endif;


//start loop - adding classes to products ul
global $woocommerce;
if ( !empty( $woocommerce )) :
	if ( version_compare( $woocommerce->version, '3.3', "<" ) ) :
		if ( ! function_exists( 'woocommerce_product_loop_start' ) ) :
			function woocommerce_product_loop_start( $echo = true ) {
				//id products is necessary for scripts
				$html                                = '<ul class="products list-unstyled grid-view">';
				$GLOBALS['woocommerce_loop']['loop'] = 0;
				if ( $echo ) {
					echo wp_kses_post( $html );
				} else {
					return $html;
				}
			}
		endif;
	else:
		add_filter( 'woocommerce_product_loop_start', 'enginx_filter_products_product_loop_start' );

		if ( ! function_exists( 'enginx_filter_products_product_loop_start' ) ) :
			function enginx_filter_products_product_loop_start( $html ) {
				return str_replace( '<ul class="products', '<ul class="products list-unstyled grid-view', $html );
			}
		endif;
	endif;
endif;

//single product view
//single product image and summary layout

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );

add_action( 'woocommerce_before_single_product', 'enginx_action_echo_div_columns_before_single_product' );
if ( ! function_exists( 'enginx_action_echo_div_columns_before_single_product' ) ):
	function enginx_action_echo_div_columns_before_single_product() {
		$column_classes = enginx_get_columns_classes();
		echo '<div id="content_product" class="' . esc_attr( $column_classes[ 'main_column_class' ] ) . '">';
	}
endif;

add_action( 'woocommerce_after_single_product', 'enginx_action_echo_div_columns_after_single_product' );
if ( ! function_exists( 'enginx_action_echo_div_columns_after_single_product' ) ):
	function enginx_action_echo_div_columns_after_single_product() {
		echo '</div> <!-- eof .col- -->';
		$column_classes = enginx_get_columns_classes();
		if ( $column_classes[ 'sidebar_class' ] ): ?>
			<!-- main aside sidebar -->
			<aside class="<?php echo esc_attr( $column_classes[ 'sidebar_class' ] ); ?>">
				<?php get_sidebar(); ?>
			</aside>
			<!-- eof main aside sidebar -->
			<?php
		endif;
	}
endif;
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_filter( 'woocommerce_single_product_image_html', 'enginx_filter_put_onsale_span_in_main_image' );
if ( ! function_exists( 'enginx_filter_put_onsale_span_in_main_image' ) ):
	function enginx_filter_put_onsale_span_in_main_image( $html ) {
		return $html . woocommerce_show_product_sale_flash();
	}
endif;

//elements in single product summary
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );

add_action( 'woocommerce_before_add_to_cart_button', 'enginx_action_echo_open_div_before_add_to_cart_button' );
if ( ! function_exists( 'enginx_action_echo_open_div_before_add_to_cart_button' ) ):
	function enginx_action_echo_open_div_before_add_to_cart_button() {
		echo '<div class="add-to-cart">';
		echo '<div class="price-product">';
			woocommerce_template_single_price();
		echo '</div>';
	}
endif;

add_action( 'woocommerce_after_add_to_cart_button', 'enginx_action_echo_open_div_after_add_to_cart_button' );
if ( ! function_exists( 'enginx_action_echo_open_div_after_add_to_cart_button' ) ):
	function enginx_action_echo_open_div_after_add_to_cart_button() {
		echo '</div>';
	}
endif;

//account navigation
add_action( 'woocommerce_before_account_navigation', 'enginx_action_woocommerce_before_account_navigation' );
if ( ! function_exists( 'enginx_action_woocommerce_before_account_navigation' ) ):
	function enginx_action_woocommerce_before_account_navigation() {
		echo '<div class="buttons">';
	}
endif;

add_action( 'woocommerce_after_account_navigation', 'enginx_action_woocommerce_after_account_navigation' );
if ( ! function_exists( 'enginx_action_woocommerce_after_account_navigation' ) ):
	function enginx_action_woocommerce_after_account_navigation() {
		echo '</div><!-- eof .buttons -->';
	}
endif;

add_action( 'woocommerce_after_single_product_summary', 'woocommerce_heading_related_product', 15 );
if ( ! function_exists( 'woocommerce_heading_related_product' ) ):
	function woocommerce_heading_related_product() {
		echo '<h3 class="gradient-title text-center">';
		echo wp_kses_post( esc_html__('Best ', 'enginx' ) .  '<span>' . esc_html__( 'Sellers', 'enginx') . '</span>' );
		echo '</h3>';
		echo '<h6 class="text-center sub-title">';
		echo esc_html__( 'The Car Repair Appointment', 'enginx' );
		echo '</h6>';
	}
endif;

add_action( 'woocommerce_after_single_product_summary', 'woocommerce_heading_related_product', 15 );
if ( ! function_exists( 'woocommerce_heading_related_product' ) ):
	function woocommerce_heading_related_product() {
		echo '<h3 class="gradient-title text-center">';
		echo wp_kses_post( esc_html__('Best ', 'enginx' ) .  '<span>' . esc_html__( 'Sellers', 'enginx') . '</span>' );
		echo '</h3>';
		echo '<h6 class="text-center sub-title">';
		echo esc_html__( 'The Car Repair Appointment', 'enginx' );
		echo '</h6>';
	}
endif;

remove_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 10 );
add_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 15 );

//mini cart
add_filter( 'woocommerce_cart_item_thumbnail', 'enginx_filter_minicart_thumbnail', 10, 3 );
if ( ! function_exists( 'enginx_filter_minicart_thumbnail') ):
	function enginx_filter_minicart_thumbnail( $product_image,  $cart_item, $cart_item_key  ){
		$link = get_permalink( $cart_item['product_id'] );
		$html = $product_image;
		if ( !empty( $link) ) {
			$html .= '</a>';
		}
		$html .= '<div class="minicart-product-meta">';
		if ( !empty( $link) ) {
			$html .= '<a href="' . esc_url( $link ) . '">';
		}
		return $html;
	}
endif;

add_action( 'woocommerce_before_mini_cart_contents', 'woocommerce_mini_cart_contents', 15 );
if ( ! function_exists( 'woocommerce_mini_cart_contents' ) ):
	function woocommerce_mini_cart_contents() {
		echo '<h3 class="gradient-title">';
		echo wp_kses_post( esc_html__('Shopping ', 'enginx' ) .  '<span>' . esc_html__( 'Cart', 'enginx') . '</span>' );
		echo '</h3>';
	}
endif;

add_filter( 'woocommerce_widget_cart_item_quantity', 'enginx_filter_minicart_item_quantity', 10, 3 );
if ( ! function_exists( 'enginx_filter_minicart_item_quantity') ):
	function enginx_filter_minicart_item_quantity( $span,  $cart_item, $cart_item_key  ){
		$link = get_permalink( $cart_item['product_id'] );
		$html = '' ;
		if ( !empty( $link) ) {
			$html .= '</a>';
		}
		$html .= $span . '</div><!-- .minicart-product-meta -->';
		return $html;
	}
endif;

