<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$options = enginx_get_options();
$section = enginx_get_section_options( $options, 'header_' );

//get topline
get_template_part( 'template-parts/toplogo/toplogo-2' );

?>
<header class="page_header nav-bordered icon-menu s-py-10 s-py-xl-0 <?php echo esc_attr( $section['section_class'] ); ?>"
	<?php echo ( !empty( $section['section_id'] ) ) ? 'id="'. esc_attr( $section['section_id'] ) . '"' : ''; ?>
	<?php echo ( !empty( $section['section_background_image'] ) ) ? 'style="'. esc_attr( $section['section_background_image'] ) . '"' : ''; ?>
>
	<div class="particles-js" id="<?php echo esc_attr( uniqid('par-') ); ?>"></div>
	<div class="container<?php echo esc_attr( $section['section_container_class_suffix'] ); ?>">
		<div class="row align-items-center">
			<div class="d-xl-none col-10">
				<div class="mr-auto">
					<?php get_template_part( 'template-parts/logo/header-logo' ); ?>
				</div>
			</div>
			<div class="col-xl-8 col-lg-6 col-1 text-sm-center">
				<!-- main nav start -->
				<nav class="top-nav">
				<?php
					wp_nav_menu( array(
						'theme_location' => 'primary',
						'menu_class'     => 'sf-menu nav',
						'container'      => 'ul'
					) );
				?>
				</nav>
			</div>
			<div class="col-xl-2 col-lg-3 text-right d-none d-xl-block">
				<ul class="top-includes">
					<li>
						<a href="#" class="search_modal_button">
							<i class="fa fa-search"></i>
						</a>
					</li>
					<?php if ( class_exists( 'WC_Widget_Cart' ) ) : ?>
						<li class="cart-dropdown">
							<div class="dropdown shop-card-dropdown">
								<a class="dropdown-toggle dropdown-shopping-cart" href="#" role="button" id="dropdown-cart" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<?php
										echo '<span class="badge bg-maincolor cart-count">';
											if (  WC()->cart->get_cart_contents_count() !== 0 ) {
												echo esc_html( WC()->cart->get_cart_contents_count() );
											}
										echo '</span>';
									?>
									<i class="ico-shopping-bag"></i>
								</a>
								<div class="dropdown-menu dropdown-menu-right ls" aria-labelledby="dropdown-cart">
									<?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>
								</div>
							</div>
						</li><!-- eof woo cart -->
					<?php endif; //woocommerce ?>

					<li class="dropdown-account">
						<a href="#" class="login_modal_window modal_window"><i class="fa fa-user mr-2"></i></a>
					</li>
				</ul>
			</div>

		</div>
		<!-- header toggler -->
		<span class="toggle_menu"><span></span></span>
	</div>
</header>
