<?php
/**
 * The template for displaying 404 pages (Not Found)
 */

get_header();

$options = enginx_get_options();
$section = enginx_get_section_options($options, '404_');
?>
<section class="page_404 <?php echo esc_attr( $section['section_class'] ); ?>"
	<?php echo ( !empty( $section['section_id'] ) ) ? 'id="'. esc_attr( $section['section_id'] ) . '"' : ''; ?>
	<?php echo ( !empty( $section['section_background_image'] ) ) ? 'style="'. esc_attr( $section['section_background_image'] ) . '"' : ''; ?>
>
	<div class="divider-15"></div>
	<div class="container<?php echo esc_attr( $section['section_container_class_suffix'] ); ?>">
		<div class="row<?php echo esc_attr( $section['section_row_class_suffix'] ); ?>">
<?php
//true - no sidebar on 404 page
$column_classes = enginx_get_columns_classes( true ); ?>
	<div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?> text-center">
		<div class="not_found"></div>
		<h2><span class="color-main"><?php esc_html_e( 'Oh, no!', 'enginx' ); ?></span><?php esc_html_e( ' Really?', 'enginx' ); ?></h2>
		<div class="not-found-buttons">
			<a href="<?php echo esc_url( home_url('/') ); ?>" class="btn btn-small btn-maincolor2">
				<?php esc_html_e( 'Go To Home', 'enginx' ); ?>

			</a>
			<span><?php esc_html_e( 'or', 'enginx' ); ?></span>
			<button class="btn btn-small btn-maincolor2" id="back-page">
				<span><?php esc_html_e( 'Return previous page', 'enginx' ); ?></span>
			</button>
		</div>

	</div><!--eof #content -->

<?php if ( $column_classes['sidebar_class'] ): ?>
	<!-- main aside sidebar -->
	<aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
	</aside>
	<!-- eof main aside sidebar -->
	<?php
endif;
get_footer();

