<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'label'       => array(
		'label' => esc_html__( 'Button Label', 'enginx' ),
		'desc'  => esc_html__( 'This is the text that appears on your button', 'enginx' ),
		'type'  => 'text',
		'value' => esc_html__('Submit', 'enginx' ),
	),
	'link'        => array(
		'label' => esc_html__( 'Button Link', 'enginx' ),
		'desc'  => esc_html__( 'Where should your button link to', 'enginx' ),
		'type'  => 'text',
		'value' => '#'
	),
	'target'      => array(
		'type'         => 'switch',
		'label'        => esc_html__( 'Open Link in New Window', 'enginx' ),
		'desc'         => esc_html__( 'Select here if you want to open the linked page in a new window', 'enginx' ),
		'right-choice' => array(
			'value' => '_blank',
			'label' => esc_html__( 'Yes', 'enginx' ),
		),
		'left-choice'  => array(
			'value' => '_self',
			'label' => esc_html__( 'No', 'enginx' ),
		),
	),
	'color'       => array(
		'label'   => esc_html__( 'Button Color', 'enginx' ),
		'desc'    => esc_html__( 'Choose a type for your button', 'enginx' ),
		'value'   => 'btn btn-maincolor',
		'type'    => 'select',
		'choices' => array(
			'btn btn-grey'   => esc_html__( 'Color Grey', 'enginx' ),
			'btn btn-maincolor'  => esc_html__( 'Color Main', 'enginx' ),
			'btn btn-maincolor2'  => esc_html__( 'Color Main 2', 'enginx' ),
			'btn btn-maincolor3'  => esc_html__( 'Color Main 3', 'enginx' ),
			'btn btn-outline-grey' => esc_html__( 'Outline Grey', 'enginx' ),
			'btn btn-outline-maincolor'  => esc_html__( 'Outline Color Main ', 'enginx' ),
			'btn btn-outline-maincolor2'  => esc_html__( 'Outline Color Main 2', 'enginx' ),
			'btn btn-outline-maincolor3'  => esc_html__( 'Outline Color Main 3', 'enginx' ),
			'simple_link'          => esc_html__( 'Just link', 'enginx' ),

		)
	),
	'size'       => array(
		'label'   => esc_html__( 'Button Size', 'enginx' ),
		'desc'    => esc_html__( 'Choose a size for your button', 'enginx' ),
		'value'   => 'btn-small',
		'type'    => 'select',
		'choices' => array(
			'btn-small'   => esc_html__( 'Small', 'enginx' ),
			'btn-medium'   => esc_html__( 'Medium', 'enginx' ),
			'btn-big'   => esc_html__( 'Big', 'enginx' ),
		)
	),

);