<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

//get button to add in a teaser:
$button         = fw_ext( 'shortcodes' )->get_shortcode( 'button' );
$button_options = $button->get_options();
unset( $button_options['link'] );
unset( $button_options['target'] );

$options = array(
	'style'   => array(
		'type'    => 'select',
		'label'   => esc_html__('Box Style', 'enginx'),
		'choices' => array(
			'top' => esc_html__('Icon above title', 'enginx'),
			'left' => esc_html__('Icon to the left of title', 'enginx'),
			'right' => esc_html__('Icon to the right of title', 'enginx')
		)
	),
	'background_color' => array(
		'type'    => 'select',
		'value'   => '',
		'label'   => esc_html__( 'Background color', 'enginx' ),
		'desc'    => esc_html__( 'Select background color', 'enginx' ),
		'help'    => esc_html__( 'Select one of predefined background types', 'enginx' ),
		'choices' => enginx_unyson_option_get_backgrounds_array(),
	),
	'icon'    => array(
		'type'  => 'icon-v2',
		'label' => esc_html__('Choose an Icon', 'enginx'),
	),
	'icon_style' => array(
		'type'    => 'image-picker',
		'value'   => '',
		'label'   => esc_html__( 'Icon Style', 'enginx' ),
		'desc'    => esc_html__( 'Select one of predefined icon styles.', 'enginx' ),
		'choices' => array(
			'' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/1.png',
			'bordered' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/2.png',
			'rounded bordered' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/3.png',
			'round bordered' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/4.png',
			'bg-' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/5.png',
			'rounded bg-' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/6.png',
			'round bg-' => fw_get_template_customizations_directory_uri() . '/extensions/shortcodes/shortcodes/icon-box/static/img/7.png',
		),
		'blank' => false, // (optional) if true, images can be deselected
	),
	'icon_color' => array(
		'type'    => 'select',
		'label'   => esc_html__('Icon color', 'enginx'),
		'value' => 'color-main',
		'choices' => array(
			'color-darkgrey' => esc_html__('Darkgrey', 'enginx'),
			'color-main' => esc_html__('Color Main', 'enginx'),
			'color-main2' => esc_html__('Color Main 2', 'enginx'),
			'color-main3' => esc_html__('Color Main 3', 'enginx'),
		),
	),
	'icon_font_size' => array(
		'type'    => 'select',
		'label'   => esc_html__('Icon Font Size', 'enginx'),
		'value'   => 'fs-20',
		'choices' => array(
			//12 14 16 18 20 24 28 32 36 40 56
			'' => esc_html__('Inherit', 'enginx'),
			'fs-12' => esc_html__('12px', 'enginx'),
			'fs-14' => esc_html__('14px', 'enginx'),
			'fs-16' => esc_html__('16px', 'enginx'),
			'fs-18' => esc_html__('18px', 'enginx'),
			'fs-20' => esc_html__('20px', 'enginx'),
			'fs-24' => esc_html__('24px', 'enginx'),
			'fs-28' => esc_html__('28px', 'enginx'),
			'fs-32' => esc_html__('32px', 'enginx'),
			'fs-36' => esc_html__('36px', 'enginx'),
			'fs-40' => esc_html__('40px', 'enginx'),
			'fs-56' => esc_html__('56px', 'enginx'),
		),
	),
	'title'   => array(
		'type'  => 'text',
		'label' => esc_html__( 'Title of the Box', 'enginx' ),
	),
	'content' => array(
		'type'  => 'textarea',
		'label' => esc_html__( 'Content', 'enginx' ),
		'desc'  => esc_html__( 'Enter the desired content', 'enginx' ),
	),
	'text_align' => array(
		'type'    => 'select',
		'label'   => esc_html__('Text alignment', 'enginx'),
		'value'   => 'text-left',
		'choices' => array(
			'text-left' => esc_html__('Left', 'enginx'),
			'text-center' => esc_html__('Center', 'enginx'),
			'text-right' => esc_html__('Right', 'enginx'),
		),
	),
	'link'   => array(
		'type'  => 'text',
		'label' => esc_html__( 'Optional teaser link', 'enginx' ),
	),
	'class'   => array(
		'type'  => 'text',
		'label' => esc_html__( 'Optional additional CSS class', 'enginx' ),
	),
	'button' => array(
		'type'    => 'multi-picker',
		'label'   => false,
		'desc'    => false,
		'value'   => false,
		'picker'  => array(
			'show_button' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Show button', 'enginx' ),
				'left-choice'  => array(
					'value' => '',
					'label' => esc_html__( 'No', 'enginx' ),
				),
				'right-choice' => array(
					'value' => 'button',
					'label' => esc_html__( 'Yes', 'enginx' ),
				),
			),
		),
		'choices' => array(
			''       => array(),
			'button' => $button_options,
		),
	)
);