<?php
/**
 * The default template for displaying content
 *
 * Used for index/archive.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;

$post_thumbnail        = get_the_post_thumbnail( get_the_ID() );
$additional_post_class = ( $post_thumbnail ) ? 'cover-image ds bs cover-image s-overlay' : '';
?>
<article
        id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding ' . $additional_post_class ); ?>>
	<?php
	echo empty ( $post_thumbnail ) ? '' : '';
	echo wp_kses_post( $post_thumbnail );
	?>
    <div class="item-content entry-content">
        <div class="entry-content">
			<h6 class="color-main entry-title"><?php the_title();?></h6>

			<?php
			the_content( esc_html__( '', 'enginx' ) );
			if (function_exists('mwt_share_this')) {
				enginx_share_this();
			}
			?>

        </div><!-- .entry-content -->
    </div><!-- eof .item-content -->
</article><!-- #post-## -->