<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$options = enginx_get_options();
$section = enginx_get_section_options( $options, 'toplogo_' );

//toplogo section with contact and search button
?>
<section class="page_toplogo s-pt-10 s-pb-5 s-py-lg-30 <?php echo esc_attr( $section['section_class'] ); ?>"
	<?php echo ( !empty( $section['section_id'] ) ) ? 'id="'. esc_attr( $section['section_id'] ) . '"' : ''; ?>
	<?php echo ( !empty( $section['section_background_image'] ) ) ? 'style="'. esc_attr( $section['section_background_image'] ) . '"' : ''; ?>
>
	<div class="particles-js" id="<?php echo esc_attr( uniqid('par-') ); ?>"></div>
	<div class="container<?php echo esc_attr( $section['section_container_class_suffix'] ); ?>">

		<div class="row align-items-center">
			<div class="col-12">

				<div class="d-lg-flex justify-content-lg-end align-items-lg-center">

					<div class="mr-auto d-none d-xl-block">
						<?php get_template_part( 'template-parts/logo/header-logo' ); ?>
					</div>

					<div class="d-flex justify-content-lg-end align-items-lg-center theme-meta">
						<?php if ( ! empty ( $options['meta_email'] ) ) : ?>
							<div class="media">
								<div class="icon-styled color-main fs-20">
									<i class="ico-email"></i>
								</div>
								<div class="media-body">
									<h6>
										<?php echo esc_html__('Contactez nous' , 'enginx' ); ?>
									</h6>
									<p>
										<a href="mailto:<?php echo esc_attr( $options['meta_email'] ); ?>">
											<?php echo esc_html( $options['meta_email'] ); ?>
										</a>
									</p>
								</div>
							</div><!-- .media -->
						<?php endif; ?>
						<?php if ( ! empty ( $options['meta_address'] ) ) : ?>
							<div class="media d-none d-sm-flex">
								<div class="icon-styled color-main fs-20">
									<i class="ico-placeholder"></i>
								</div>

								<div class="media-body">
									<h6>
										<?php echo esc_html__('Adresse' , 'enginx' ); ?>
									</h6>
									<p>
										<?php echo esc_html( $options['meta_address'] ); ?>
									</p>
								</div>
							</div><!-- .media -->
						<?php endif; ?>
						<?php if ( ! empty ( $options['meta_phone'] ) ) : ?>
						<div class="media">
							<div class="icon-styled color-main fs-20">
								<i class="ico-phone-call"></i>
							</div>

							<div class="media-body">
								<h6>
									<?php echo esc_html__('Téléphone' , 'enginx' ); ?>
								</h6>
								<p>
									<?php echo esc_html( $options['meta_phone'] ); ?>
								</p>
							</div>
						</div><!-- .media -->
						<?php endif; ?>

					</div><!-- .d-none -->
					<div class="d-none d-lg-flex">
						<?php foreach ($options['header_buttons'] as $button) :?>
							<a href="<?php echo esc_attr( $button['link'] ) ?>"
							   target="<?php echo esc_attr( $button['target'] ) ?>"
							   class="<?php echo esc_attr( $button['color'] . ' ' . $button['size']); ?>">
								<span><?php echo esc_html( $button['label'] ); ?></span>
							</a>
						<?php endforeach;?>
					</div>
				</div><!-- .d-lg-flex -->

			</div>
		</div>
	</div>
</section><!-- .page_toplogo -->
