<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * @var array $atts
 * @var array $posts
 */

//1 - col-*-12
//2 - col-*-6
//3 - col-*-4
//4 - col-*-3
//6 - col-*-2

//bootstrap col-lg-* class
$lg_class = '';
switch ( $atts['responsive_lg'] ) :
	case ( 1 ) :
		$lg_class = 'col-lg-12';
		break;

	case ( 2 ) :
		$lg_class = 'col-lg-6';
		break;

	case ( 3 ) :
		$lg_class = 'col-lg-4';
		break;

	case ( 4 ) :
		$lg_class = 'col-lg-3';
		break;
	//6
	default:
		$lg_class = 'col-lg-2';
endswitch;

//bootstrap col-md-* class
$md_class = '';
switch ( $atts['responsive_md'] ) :
	case ( 1 ) :
		$md_class = 'col-md-12';
		break;

	case ( 2 ) :
		$md_class = 'col-md-6';
		break;

	case ( 3 ) :
		$md_class = 'col-md-4';
		break;

	case ( 4 ) :
		$md_class = 'col-md-3';
		break;
	//6
	default:
		$md_class = 'col-md-2';
endswitch;

//bootstrap col-sm-* class
$sm_class = '';
switch ( $atts['responsive_sm'] ) :
	case ( 1 ) :
		$sm_class = 'col-sm-12';
		break;

	case ( 2 ) :
		$sm_class = 'col-sm-6';
		break;

	case ( 3 ) :
		$sm_class = 'col-sm-4';
		break;

	case ( 4 ) :
		$sm_class = 'col-sm-3';
		break;
	//6
	default:
		$sm_class = 'col-sm-2';
endswitch;

//bootstrap col-xs-* class
$xs_class = '';
switch ( $atts['responsive_xs'] ) :
	case ( 1 ) :
		$xs_class = 'col-xs-12';
		break;

	case ( 2 ) :
		$xs_class = 'col-xs-6';
		break;

	case ( 3 ) :
		$xs_class = 'col-xs-4';
		break;

	case ( 4 ) :
		$xs_class = 'col-xs-3';
		break;
	//6
	default:
		$xs_class = 'col-xs-2';
endswitch;

//column paddings class
//margin values:
//0
//1
//2
//10
//30
$margin_class = '';
switch ( $atts['margin'] ) :
	case ( 0 ) :
		$margin_class = 'c-gutter-0';
		break;

	case ( 1 ) :
		$margin_class = 'c-gutter-1 c-mb-1';
		break;

	case ( 2 ) :
		$margin_class = 'c-gutter-2 c-mb-2';
		break;

	case ( 10 ) :
		$margin_class = 'c-gutter-10 c-mb-10';
		break;
	//30
	default:
		$margin_class = 'c-gutter-30 c-mb-30';
endswitch;

$unique_id = uniqid();

$categories = fw_ext_extension_get_listing_categories( $atts['cat'], 'services' );
$sort_classes = fw_ext_extension_get_sort_classes( $posts->posts, $categories, '', 'services' );

if ( $atts['show_filters'] ) : ?>
	<div class="filters isotope_filters-<?php echo esc_attr( $unique_id ); ?> text-center">
		<a href="#" data-filter="*" class="selected"><?php esc_html_e( 'All', 'mwt' ); ?></a>
		<?php
		foreach ( $categories as $category ) {
			?>
			<a href="#"
			   data-filter=".<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name ); ?></a>
			<?php
		} //foreach
		?>
	</div>
	<?php
endif; //showfilters check ?>

<div class="isotope-wrapper isotope row masonry-layout <?php echo esc_attr( $margin_class ); ?>"
	<?php if ( $atts['show_filters'] ) : ?>
		data-filters=".isotope_filters-<?php echo esc_attr( $unique_id ); ?>"
	<?php endif; // filters ?>
>
	<?php
		$counter = 0;
	?>
	<?php while ( $posts->have_posts() ) : $posts->the_post();
			$counter++;
			$xl_class = 'col-xl-2';
			$thumbnail_size = 'large';
			if( $counter === 3 || $counter === 4 || $counter === 7 ) {
				$xl_class = 'col-xl-4';
				if( $counter === 4 || $counter === 7 ) {
					$thumbnail_size = array(400, 200);
				}

			}
		?>
		<div class="isotope-item <?php echo esc_attr( $xl_class . ' '
													 . $lg_class . ' '
													 . $md_class . ' '
													 . $sm_class . ' '
													 . $xs_class . ' '
													 . $sort_classes[ get_the_ID() ] ); ?>"
		>
			<?php
			if ( get_the_post_thumbnail() ) :
				?>
				<article <?php post_class( 'vertical-item gallery-item content-absolute text-center cs' ) ?>">
				<div class="item-media">
					<?php
					$full_image_src = wp_get_attachment_url( get_post_thumbnail_id( get_the_ID() ) );
					echo get_the_post_thumbnail( '', $thumbnail_size );
					?>
					<div class="media-links">
						<div class="links-wrap">
							<a class="link-zoom photoswipe-link"
							   href="<?php echo esc_attr( $full_image_src ); ?>"></a>
						</div>
					</div>
				</div>
				<div class="item-content">
					<h4 class="item-meta">
						<a href="<?php the_permalink(); ?>">
							<?php the_title(); ?>
						</a>
					</h4>
				</div>
				</article>
			<?php
			//no featured image
			else :
				?>
				<article <?php post_class( 'vertical-item gallery-item item-no-image text-center' ) ?>">
				<div class="item-content display_table_cell">
					<h4 class="item-meta">
						<a href="<?php the_permalink(); ?>">
							<?php the_title(); ?>
						</a>
					</h4>
				</div>
				</article>
			<?php endif; //get_the_post_thumbnail ?>

		</div>
	<?php endwhile; ?>
	<?php wp_reset_postdata(); // reset the query ?>
</div><!-- eof .isotope-wrapper -->
