<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Shortcode Posts - extended item layout
 */

$terms          = get_the_terms( get_the_ID(), 'category' );
$filter_classes = '';
foreach ( $terms as $term ) {
	$filter_classes .= ' filter-' . $term->slug;
}
?>
<article <?php post_class( "vertical-item content-padding hero-bg bordered text-center featured-post" . $filter_classes ); ?>>
	<?php if ( get_the_post_thumbnail() ) : ?>
		<div class="item-media-wrap">
			<div class="item-media">
				<?php echo get_the_post_thumbnail('' ,'enginx-full-width',''); ?>
				<div class="media-links">
					<a class="abs-link" href="<?php the_permalink(); ?>"></a>
				</div>
			</div>
		</div>

	<?php endif; //eof thumbnail check ?>
	<div class="item-content">
		<h4 class="entry-title">
			<a href="<?php the_permalink(); ?>">
				<?php the_title(); ?>
			</a>
		</h4>
		<?php
		if( function_exists( 'enginx_the_excerpt' ) ) :
			 if ( ! empty( get_the_tags() ) && !enginx_get_option( 'blog_hide_tags' ) ) : ?>
				<div class="tagcloud sticky-tags d-block">
					<?php the_tags( '', '', '' ); ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		<?php
			if( function_exists( 'enginx_the_excerpt' ) ) :
			enginx_the_excerpt( array(
				'length' => 10,
				'before' => '<div class="excerpt"><p>',
				'after'  => '</p></div>',
				'more'	=> '',
			) );
			endif;
		?>
		<?php if( function_exists( 'mwt_post_like_button' ) ) : ?>
			<div class="item-icons links-grey d-flex justify-content-between">
				<?php
				if (function_exists('enginx_the_date') ) :
				enginx_the_date(
					array(
						'before' => '<span><i class="fs-14 color-main ico-clock-alt"></i>',
						'after' => '</span>',
						'link_attributes' => 'rel="bookmark"',
						'time_tag_class' => 'entry-date',
						'days_ago' => true
					) );
				endif;
				if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) :
				?>
				<div>
					<?php endif; //password ?>
					<?php
					if (function_exists('enginx_post_like_button')) :
						enginx_post_like_button( get_the_ID() );
						enginx_post_like_count( get_the_ID() );
					endif; ?>
					<span class="comments-link">
						<i class="fs-14 color-main ico-comments-alt"></i>
						<?php comments_popup_link( esc_html__( '0', 'enginx' ), esc_html__( '1', 'enginx' ), esc_html__( '%', 'enginx' ) ); ?>
					</span>
				</div>
			</div>
		<?php endif; //mwt_post_like_button ?>
	</div>
</article><!-- eof vertical-item -->
