<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(

	'heading_align' => array(
		'type'    => 'select',
		'value'   => 'text-left',
		'label'   => esc_html__( 'Text alignment', 'enginx' ),
		'desc'    => esc_html__( 'Select heading text alignment', 'enginx' ),
		'choices' => array(
			'text-left'   => esc_html__( 'Left', 'enginx' ),
			'text-center' => esc_html__( 'Center', 'enginx' ),
			'text-right'  => esc_html__( 'Right', 'enginx' ),
		),

	),
	'headings'      => array(
		'type'        => 'addable-box',
		'value'       => '',
		'label'       => esc_html__( 'Headings', 'enginx' ),
		'desc'        => esc_html__( 'Choose a tag and text inside it', 'enginx' ),
		'box-options' => array(
			'heading_icon' => array(
				'type'  => 'icon-v2',
				'preview_size' => 'medium',
				'modal_size' => 'medium',
				'label' => esc_html__('Optional icon', 'enginx'),
			),
			'heading_tag'            => array(
				'type'    => 'select',
				'value'   => 'h3',
				'label'   => esc_html__( 'Heading tag', 'enginx' ),
				'desc'    => esc_html__( 'Select a tag for your', 'enginx' ),
				'choices' => array(
					'h1' => esc_html__( 'H1 tag', 'enginx' ),
					'h2' => esc_html__( 'H2 tag', 'enginx' ),
					'h3' => esc_html__( 'H3 tag', 'enginx' ),
					'h4' => esc_html__( 'H4 tag', 'enginx' ),
					'h5' => esc_html__( 'H5 tag', 'enginx' ),
					'h6' => esc_html__( 'H6 tag', 'enginx' ),
					'p'  => esc_html__( 'P tag', 'enginx' ),

				),
			),
			'heading_text'           => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Heading text', 'enginx' ),
				'desc'  => esc_html__( 'Text to appear in slide layer', 'enginx' ),
			),
			'heading_text_color'     => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text color', 'enginx' ),
				'desc'    => esc_html__( 'Select a color for your text in layer', 'enginx' ),
				'choices' => array(
					''            => esc_html__( 'Inherited', 'enginx' ),
					'color-main'  => esc_html__( 'Color Main', 'enginx' ),
					'color-main2' => esc_html__( 'Color Main 2', 'enginx' ),
					'color-main3' => esc_html__( 'Color Main 3', 'enginx' ),
					'color-dark'  => esc_html__( 'Dark Color', 'enginx' ),
					'color-grey'  => esc_html__( 'Grey Color', 'enginx' ),
				),
			),
			'heading_text_weight'    => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text weight', 'enginx' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'enginx' ),
				'choices' => array(
					''     => esc_html__( 'Normal', 'enginx' ),
					'thin' => esc_html__( 'Thin', 'enginx' ),
					'fw-700' => esc_html__( 'Semi Bold', 'enginx' ),
					'bold' => esc_html__( 'Bold', 'enginx' ),

				),
			),
			'heading_text_transform' => array(
				'type'    => 'select',
				'value'   => '',
				'label'   => esc_html__( 'Heading text transform', 'enginx' ),
				'desc'    => esc_html__( 'Select a weight for your text in layer', 'enginx' ),
				'choices' => array(
					''                => esc_html__( 'None', 'enginx' ),
					'text-lowercase'  => esc_html__( 'Lowercase', 'enginx' ),
					'text-uppercase'  => esc_html__( 'Uppercase', 'enginx' ),
					'text-capitalize' => esc_html__( 'Capitalize', 'enginx' ),

				),
			),
			'heading_text_link' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__('Heading link', 'enginx'),
				'desc'  => esc_html__('Add a link to your special heading', 'enginx'),
			),
		),
		'template'    => '{{- heading_text }}',
	)
);
