<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'tabs'       => array(
		'type'          => 'addable-popup',
		'label'         => esc_html__( 'Tabs', 'enginx' ),
		'popup-title'   => esc_html__( 'Add/Edit Tabs', 'enginx' ),
		'desc'          => esc_html__( 'Create your tabs', 'enginx' ),
		'template'      => '{{=tab_title}}',
		'popup-options' => array(
			'tab_title'          => array(
				'type'  => 'text',
				'label' => esc_html__( 'Tab Title', 'enginx' )
			),
			'tab_content'        => array(
				'type'  => 'wp-editor',
				'label' => esc_html__( 'Tab Content', 'enginx' ),
			),
			'tab_featured_image' => array(
				'type'        => 'upload',
				'value'       => '',
				'label'       => esc_html__( 'Tab Featured Image', 'enginx' ),
				'image'       => esc_html__( 'Featured image for your tab', 'enginx' ),
				'help'        => esc_html__( 'Image for your tab. It appears on the top of your tab content', 'enginx' ),
				'images_only' => true,
			),
			'tab_icon'           => array(
				'type'  => 'icon',
				'label' => esc_html__( 'Icon in tab title', 'enginx' ),
				'set'   => 'theme-fa-icons',
			),
		),
	),
	'small_tabs' => array(
		'type'         => 'switch',
		'value'        => '',
		'label'        => esc_html__( 'Small Tabs', 'enginx' ),
		'desc'         => esc_html__( 'Decrease tabs size', 'enginx' ),
		'left-choice'  => array(
			'value' => '',
			'label' => esc_html__( 'No', 'enginx' ),
		),
		'right-choice' => array(
			'value' => 'small-tabs',
			'label' => esc_html__( 'Yes', 'enginx' ),
		),
	),
	'id'         => array( 'type' => 'unique' ),
);