<?php
/**
 * The Template for displaying all single posts
 */

get_header();
$column_classes = enginx_get_columns_classes();

$share_buttons_classes = function_exists( 'mwt_share_this' ) && enginx_is_share_buttons_active() ? 'post-share-buttons' : '';

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;
$time = enginx_get_option('blog_change_date' );
?>
	<div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?>">
		<?php

		// Start the Loop.
		while ( have_posts() ) : the_post();
			/*
			 * Include the post format-specific template for the content. If you want to
			 * use this in a child theme, then include a file called called content-___.php
			 * (where ___ is the post format) and that will be used instead.
			 */
			?>
	<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item single-post ' . $share_buttons_classes ); ?>>
		<?php enginx_post_thumbnail();?>
		<div class="affix-aside">
			<?php
				if( $share_buttons_classes ) {
					enginx_share_this();
				}
			?>
		</div>
		<div class="item-content">
		<?php if ( ! empty( get_the_tags() ) && !enginx_get_option( 'blog_hide_tags' ) ) : ?>
			<div class="tagcloud sticky-tags d-block">
				<?php the_tags( '', '', '' ); ?>
			</div>
		<?php endif; ?>
		<div class="entry-content">
			<?php
			the_content( esc_html__( '', 'enginx' ) );
			?>
		</div><!-- .entry-content -->

		<?php
		wp_link_pages( array(
			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'enginx' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
		) );
		?>
			<div class="entry-meta">
				<div class="byline">
					<?php
					enginx_the_author(
						array(
							'before' => '<span><i class="fs-14 color-main ico-user"></i>' . esc_html__( '', 'enginx' ),
							'after' => '</span>',
							'link_class' => 'url fn n',
							'link_attributes' => 'rel="author"',
						) );
					enginx_the_date(
						array(
							'before' => '<span><i class="fs-14 color-main ico-clock-alt"></i>',
							'after' => '</span>',
							'link_attributes' => 'rel="bookmark"',
							'time_tag_class' => 'entry-date',
							'days_ago' => $time
						) );
					?>
					<span class="comments-link">
						<i class="fs-14 color-main ico-comments-alt"></i>
						<?php comments_popup_link( esc_html__( '0', 'enginx' ), esc_html__( '1', 'enginx' ), esc_html__( '%', 'enginx' ) ); ?>
					</span>
					<span>
						<?php
						enginx_post_like_button( get_the_ID() );
						enginx_post_like_count( get_the_ID() );
						?>
					</span> <!-- eof .post-adds -->
					<?php if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && enginx_categorized_blog() &&  ! enginx_get_option( 'blog_hide_categories' ) ) :
					enginx_the_categories();
					endif; ?>
				</div>
			</div><!-- .entry-meta -->
			<hr>
		</div>
	<?php
		// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || get_comments_number() ) {
			comments_template();
		}
	endwhile; ?>
	</article><!-- #post-## -->

	</div><!--eof #content -->
<?php if ( $column_classes['sidebar_class'] ): ?>
	<!-- main aside sidebar -->
	<aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
	</aside>
	<!-- eof main aside sidebar -->
	<?php
endif;
get_footer();