<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
$dividers_height = array( '0', '5', '10', '15', '20', '25', '30', '35', '40', '45', '50', '55', '60', '65', '70', '80', '90', '95', '100', '120', '130', '145' );
//
//sm: 576px,
//md: 768px,
//lg: 992px,
//xl: 1200px
//
$breakpoints = array( 'sm', 'md', 'lg', 'xl' );

$choices = array( '' => '-' );
foreach ( $dividers_height as $height ) {
	$choices[$height] = $height . esc_html__( 'px', 'enginx' );
}

$height_options = array(
	'all' => array(
		'type' => 'select',
		'value' => '',
		'label' => esc_html__( 'Height', 'enginx' ),
		'choices' => $choices,
	)
);

foreach ( $breakpoints as $breakpoint) {
	$choices = array( '' => '-' );
	foreach ( $dividers_height as $height ) {
		$choices[$height] = $height . esc_html__( 'px', 'enginx' );
	}
	$height_options[$breakpoint] = array(
		'type' => 'select',
		'value' => '',
		'label' => esc_html__( 'Height on ', 'enginx' ) . strtoupper( $breakpoint ) . esc_html__( ' screens', 'enginx' ),
		'choices' => $choices,
	);
}

$options = array_merge( array(
	'unique_id' => array(
		'type' => 'unique',
		'length' => 7
	),
), $height_options );
