<?php

/**
 * TGM Plugin Activation
 */
require_once ENGINX_THEME_PATH . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';

if ( ! function_exists( 'enginx_action_register_required_plugins' ) ):
	/** @internal */
	function enginx_action_register_required_plugins() {
		tgmpa( array (
			array (
				'name'             => esc_html__('Unyson', 'enginx'),
				'slug'             => 'unyson',
				'required'         => true,
			),
			array (
				'name'             => esc_html__('MWTemplates Theme Addons','enginx'),
				'slug'             => 'mwt-addons',
				'source'           => esc_url( 'http://webdesign-finder.com/enginx/plugins/mwt-addons.zip' ),
				'required'         => true,
				'version'          => '1.1',
			),
			array (
				'name'             => esc_html__( 'MWT Helpers', 'enginx'),
				'slug'             => 'mwt-helpers',
				'source'           => esc_url( 'http://webdesign-finder.com/enginx/plugins/mwt-helpers.zip'),
				'required'         => true,
			),
			array (
				'name'             => esc_html__( 'Booked', 'enginx'),
				'slug'             => 'booked',
				'source'           => esc_url( 'http://webdesign-finder.com/enginx/plugins/booked.zip'),
				'required'         => true,
			),
			array(
				'name'             => esc_html__( 'Widget CSS Classes', 'enginx' ),
				'slug'             => 'widget-css-classes',
				'required'         => false,
			),
			array (
				'name'             => esc_html__( 'MailChimp', 'enginx'),
				'slug'             => 'mailchimp-for-wp',
				'required'         => true,
			),
			array(
				'name'             => esc_html__( 'Classic Editor', 'enginx'),
				'slug'             => 'classic-editor',
				'required'         => true,
			),
			array(
				'name'             =>  esc_html__( 'User custom avatar', 'enginx' ),
				'slug'             => 'wp-user-avatar',
				'required'         => false,
			),
			array(
				'name'             =>  esc_html__( 'WooCommerce', 'enginx' ),
				'slug'             => 'woocommerce',
				'required'         => false,
			),
			array (
				'name'             => esc_html__('Envato Market', 'enginx'),
				'slug'             => 'envato-market',
				'source'           => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
				'required'         => true, // please do not turn to false!
			),
			array (
				'name'             => esc_html__('Snazzy Maps', 'enginx'),
				'slug'             => 'snazzy-maps',
				'source'           => 'http://webdesign-finder.com/remote-demo-content/common-plugins-original/snazzy-maps.1.1.5.zip',
				'required'         => true,
				'version'          => '1.1.5',
			),
			array(
				'name'             => esc_html__( 'Slider Revolution', 'enginx' ),
				'slug'             => 'rev-slider',
				'source'           => esc_url( 'http://webdesign-finder.com/remote-demo-content/common-plugins-original/revslider.zip' ),
				'required'         => false,
			),
			array(
				'name'             => esc_html__('WP-SCSS', 'enginx'),
				'slug'             => 'wp-scss',
				'required'         => false,
			),
		),
			array(
				'domain'           => 'enginx',
				'dismissable'      => false,
				'is_automatic'     => false
			) );
	}
endif;
add_action( 'tgmpa_register', 'enginx_action_register_required_plugins' );