<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Include static files: javascript and css
 */

//removing default font awesome css style - we using our "font-awesome.css" file which contain font awesome
wp_deregister_style( 'fw-font-awesome' );
wp_deregister_style( 'font-awesome' );

//Add Theme Fonts
wp_enqueue_style(
	'font-awesome',
	ENGINX_THEME_URI . '/css/font-awesome.css',
	array(),
	ENGINX_THEME_VERSION
);

//Add Flaticon Fonts
wp_enqueue_style(
	'flaticon-custom',
	ENGINX_THEME_URI . '/css/flaticon.css',
	array(),
	ENGINX_THEME_VERSION
);

//Add Icomoon Fonts
wp_enqueue_style(
	'icomoon',
	ENGINX_THEME_URI . '/css/icomoon.css',
	array(),
	ENGINX_THEME_VERSION
);

if ( is_admin_bar_showing() ) {
	//Add Frontend admin styles
	wp_register_style(
		'enginx-admin_bar',
		ENGINX_THEME_URI . '/css/admin-frontend.css',
		array(),
		ENGINX_THEME_VERSION
	);
	wp_enqueue_style( 'enginx-admin_bar' );
}

//styles and scripts below only for frontend: if in dashboard - exit
if ( is_admin() ) {
	return;
}

/**
 * Enqueue scripts and styles for the front end.
 */
// Add theme google font, used in the main stylesheet.
wp_enqueue_style(
	'enginx-google-font',
	enginx_google_font_url(),
	array(),
	ENGINX_THEME_VERSION
);

if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}

if ( is_singular() && wp_attachment_is_image() ) {
	wp_enqueue_script(
		'enginx-keyboard-image-navigation',
		ENGINX_THEME_URI . '/js/keyboard-image-navigation.js',
		array( 'jquery' ),
		ENGINX_THEME_VERSION
	);
}

//plugins theme script
wp_enqueue_script(
	'enginx-modernizr',
	ENGINX_THEME_URI . '/js/vendor/modernizr-custom.js',
	false,
	'2.6.2',
	false
);

//plugins theme script
//replacing one compressed script with uncompressed versions - new theme requirements
wp_enqueue_script( 'bootstrap-bundle', ENGINX_THEME_URI . '/js/vendor/bootstrap.bundle.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'affix', ENGINX_THEME_URI . '/js/vendor/affix.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'appear', ENGINX_THEME_URI . '/js/vendor/jquery.appear.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'cookie', ENGINX_THEME_URI . '/js/vendor/jquery.cookie.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'easing', ENGINX_THEME_URI . '/js/vendor/jquery.easing.1.3.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'hoverIntent', ENGINX_THEME_URI . '/js/vendor/jquery.hoverIntent.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'superfish', ENGINX_THEME_URI . '/js/vendor/superfish.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'progressbar', ENGINX_THEME_URI . '/js/vendor/bootstrap-progressbar.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'countdown', ENGINX_THEME_URI . '/js/vendor/jquery.countdown.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'countTo', ENGINX_THEME_URI . '/js/vendor/jquery.countTo.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'easypiechart', ENGINX_THEME_URI . '/js/vendor/jquery.easypiechart.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'scrollbar', ENGINX_THEME_URI . '/js/vendor/jquery.scrollbar.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'localScroll', ENGINX_THEME_URI . '/js/vendor/jquery.localScroll.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'scrollTo', ENGINX_THEME_URI . '/js/vendor/jquery.scrollTo.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'totop', ENGINX_THEME_URI . '/js/vendor/jquery.ui.totop.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'parallax', ENGINX_THEME_URI . '/js/vendor/jquery.parallax-1.1.3.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'isotope', ENGINX_THEME_URI . '/js/vendor/isotope.pkgd.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'flexslider', ENGINX_THEME_URI . '/js/vendor/jquery.flexslider-min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'owlcarousel', ENGINX_THEME_URI . '/js/vendor/owl.carousel.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'photoswipe', ENGINX_THEME_URI . '/js/vendor/photoswipe.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'photoswipe-default', ENGINX_THEME_URI . '/js/vendor/photoswipe-ui-default.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
wp_enqueue_script( 'particles', ENGINX_THEME_URI . '/js/vendor/particles.min.js', array('jquery'), ENGINX_THEME_VERSION, true );
//getting theme color scheme number
$color_scheme_number = enginx_get_option('color_scheme_number', '' );

//if WooCommerce - remove prettyPhoto - we have one in "compressed.js"
if ( class_exists( 'WooCommerce' ) ) :

	// Add Theme Woo Styles and Scripts
	wp_enqueue_style(
		'enginx-woo',
		ENGINX_THEME_URI . '/css/shop' . esc_attr( $color_scheme_number ) . '.css',
		array(),
		ENGINX_THEME_VERSION
	);

	//you can include Woo related scripts here
endif; //WooCommerce

//main theme script
wp_enqueue_script(
	'enginx-main',
	ENGINX_THEME_URI . '/js/main.js',
	array( 'jquery' ),
	ENGINX_THEME_VERSION,
	true
);

//if AccessPress is active
if ( class_exists( 'SC_Class' ) ) :
	wp_deregister_style( 'fontawesome-css' );
	wp_deregister_style( 'apsc-frontend-css' );
	wp_enqueue_style(
		'enginx-accesspress',
		ENGINX_THEME_URI . '/css/accesspress.css',
		array(),
		ENGINX_THEME_VERSION
	);
endif; //AccessPress

//Add Theme Booked Styles
if( class_exists('booked_plugin')) {
	wp_dequeue_style('booked-styles');
	wp_dequeue_style('booked-responsive');
	wp_enqueue_style(
		'enginx-booked',
		ENGINX_THEME_URI . '/css/booked' . esc_attr( $color_scheme_number ) . '.css',
		array(),
		ENGINX_THEME_VERSION
	);
}//Booked

// Add Bootstrap Style
wp_enqueue_style(
	'bootstrap',
	ENGINX_THEME_URI . '/css/bootstrap.min.css',
	array(),
	ENGINX_THEME_VERSION
);

// Add Animations Style
wp_enqueue_style(
	'enginx-animations',
	ENGINX_THEME_URI . '/css/animations.css',
	array(),
	ENGINX_THEME_VERSION
);

// Add Theme Style
wp_enqueue_style(
	'enginx-main',
	ENGINX_THEME_URI . '/css/main' . esc_attr( $color_scheme_number ) . '.css',
	array(),
	ENGINX_THEME_VERSION
);

// Add Theme stylesheet.
wp_enqueue_style( 'enginx-style', get_stylesheet_uri(), array(), ENGINX_THEME_VERSION );

wp_add_inline_style( 'enginx-main', enginx_add_font_styles_in_head() );
wp_add_inline_style( 'enginx-main', enginx_custom() );

if( defined('FW') ) :

	//function for enqueue styles and scripts for section video background
	if (! function_exists( 'enginx_unyson_enqueue_section_video_background_scripts' ) ) :
		function enginx_unyson_enqueue_section_video_background_scripts() {

			// fixes https://github.com/ThemeFuse/Unyson/issues/1552
			{
				global $is_safari;

				if ($is_safari) {
					wp_enqueue_script('youtube-iframe-api', 'https://www.youtube.com/iframe_api');
				}
			}

			wp_enqueue_style(
				'enginx-shortcode-section-background-video',
				ENGINX_THEME_URI . '/framework-customizations/extensions/shortcodes/shortcodes/section/static/css/background.css'
			);

			wp_enqueue_script(
				'enginx-shortcode-section-formstone-core',
				ENGINX_THEME_URI . '/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/core.js',
				array( 'jquery' ),
				false,
				true
			);
			wp_enqueue_script(
				'enginx-shortcode-section-formstone-transition',
				ENGINX_THEME_URI . '/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/transition.js',
				array( 'jquery' ),
				false,
				true
			);
			wp_enqueue_script(
				'enginx-shortcode-section-formstone-background',
				ENGINX_THEME_URI . '/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/background.js',
				array( 'jquery' ),
				false,
				true
			);
			wp_enqueue_script(
				'enginx-shortcode-section',
				ENGINX_THEME_URI . '/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/background.init.js',
				array(
					'enginx-shortcode-section-formstone-core',
					'enginx-shortcode-section-formstone-transition',
					'enginx-shortcode-section-formstone-background'
				),
				false,
				true
			);
		}
	endif;
endif;
