<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

//get button to add:
$button = fw_ext('shortcodes')->get_shortcode('button');
$button_options = $button->get_options();

$options = array(
	'tab_main' => array(
		'type' => 'tab',
		'title' => esc_html__('Info', 'enginx'),
		'options' => array(
			'title' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Pricing plan title', 'enginx'),
			),
			'description' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Plan description', 'enginx'),
			),
			'currency' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Currency Sign', 'enginx'),
			),
			'price' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Whole price', 'enginx'),
				'desc' => esc_html__('Price before decimal divider', 'enginx'),
			),
			'price_after' => array(
				'type' => 'text',
				'value' => '',
				'label' => esc_html__('Text after price', 'enginx'),
				'desc' => esc_html__('Price after decimal divider, including divider (dot, coma etc.), for example ".99", or text "per month"', 'enginx'),
			),
			'features' => array(
				'type' => 'addable-box',
				'value' => '',
				'label' => esc_html__('Pricing plan features', 'enginx'),
				'box-options' => array(
					'price_icon'           => array(
						'type'  => 'icon',
						'label' => esc_html__( 'Icon in tab title', 'enginx' ),
						'set'   => 'theme-fa-icons',
					),
					'feature_name' => array(
						'type' => 'text',
						'value' => '',
						'label' => esc_html__('Feature name', 'enginx'),
					),
					'feature_checked' => array(
						'type' => 'select',
						'value' => '',
						'label' => esc_html__('Default, checked or unchecked', 'enginx'),
						'choices' => array(
							'default' => esc_html__('Default', 'enginx'),
							'enabled' => esc_html__('Enabled', 'enginx'),
							'disabled' => esc_html__('Disabled', 'enginx'),
						),
						'no-validate' => false,
					),
				),
				'template' => '{{=feature_name}}',
				'limit' => 0,
				'add-button-text' => esc_html__('Add', 'enginx'),
				'sortable' => true,
			),
			'featured' => array(
				'type' => 'switch',
				'value' => '',
				'label' => esc_html__('Default or featured plan', 'enginx'),
				'left-choice' => array(
					'value' => '',
					'label' => esc_html__(' Default', 'enginx'),
				),
				'right-choice' => array(
					'value' => 'plan-featured',
					'label' => esc_html__(' Featured', 'enginx'),
				),
			),
			'layout' => array(
				'label' => esc_html__('Choose layout', 'enginx'),
				'type' => 'select', // or 'short-select'
				'value' => '1',
				'choices' => array(
					'1' => esc_html__('Layout 1', 'enginx'),
					'2' => esc_html__('Layout 2', 'enginx'),
					'3' => esc_html__('Layout 3', 'enginx'),
					'4' => esc_html__('Layout 4', 'enginx'),
				),
			)
		),
	),
	'tab_button' => array(
		'type' => 'tab',
		'options' => array(
			'price_buttons'     => array(
				'type'        => 'addable-box',
				'value'       => '',
				'label'       => esc_html__( 'Price Buttons', 'enginx' ),
				'desc'        => esc_html__( 'Add a button, to price table', 'enginx' ),
				'template'    => 'Button',
				'box-options' => array(
					$button_options
				),
				'limit'           => 1, // limit the number of boxes that can be added
				'add-button-text' => esc_html__( 'Add', 'enginx' ),
			),
		),
		'title' => esc_html__('Button', 'enginx'),
	),


);