<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * The template for displaying single service
 *
 */

get_header();
$pID = get_the_ID();

//no columns on single service page
$column_classes = fw_ext_extension_get_columns_classes( true );

//getting taxonomy name
$ext_team_settings = fw()->extensions->get( 'team' )->get_settings();
$taxonomy_name = $ext_team_settings['taxonomy_name'];

$atts = fw_get_db_post_option(get_the_ID());

$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
if ( empty( $atts['image'] ) ) {
	$image = fw_get_framework_directory_uri( '/static/img/no-image.png' );
} else {
	$image = $atts['image']['url'];
}

$unique_id = uniqid();
?>
	<div id="content" class="<?php echo esc_attr( $column_classes['main_column_class'] ); ?>">
		<?php
		// Start the Loop.
		while ( have_posts() ) : the_post(); ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class('text-center text-lg-left c-gutter-30 s-pt-60 s-pb-0 s-pt-lg-90 s-pt-xl-150 team-single ls'); ?>>
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-6">
							<img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $atts['position'] ); ?>"/>
						</div>
						<!-- .col-md-6 -->
						<div class="col-lg-6 col-md-offset-1 team-content">
							<div class="vertical-item">
								<div class="divider-40 d-block d-lg-none"></div>
								<div class="item-content entry-content overflow-hidden mt-10">
									<!-- .entry-header -->
									<?php the_title( '<h3 class="gradient-title">', '</h3>' ); ?>
									<?php if ( get_the_term_list( $pID, $taxonomy_name ) ) : ?>

									<?php endif; //get_the_term_list ?>
									<?php if ( ! empty( $atts['position'] ) ) : ?>
										<p class="big color-dark"><?php echo wp_kses_post( $atts['position'] ); ?></p>
									<?php endif; //position ?>

									<?php if ( ! empty( $atts['additional_content'] ) ) : ?>
										<div class="member-additional-content">
											<?php echo wp_kses_post( $atts['additional_content'] ); ?>
										</div>
									<?php endif; //additional content ?>
									<div class="divider-90 d-none d-lg-block"></div>

									<?php if ( ! empty( $atts['social_icons'] ) ) : ?>
										<div class="team-social-icons with-border text-center">
											<?php
											if ( ! empty( $shortcodes_extension ) ) {
												echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $atts['social_icons'] ) );
											}
											?>
										</div><!-- eof social icons -->
									<?php endif; //social icons ?>
								</div>
								<!-- .entry-content -->
							</div>
							<!-- .vertical-item -->
						</div>
					</div>
				</div>
			</article><!-- #post-## -->
			<?php the_content(); ?>
		<?php endwhile; ?>
	</div><!--eof #content -->
<?php if ( $column_classes['sidebar_class'] ): ?>
	<!-- main aside sidebar -->
	<aside class="<?php echo esc_attr( $column_classes['sidebar_class'] ); ?>">
		<?php get_sidebar(); ?>
	</aside>
	<!-- eof main aside sidebar -->
<?php
endif;
get_footer();