<?php

namespace ProfilePressVendor\Stripe\Util;

class ObjectTypes
{
    /**
     * @var array Mapping from object types to resource classes
     */
    const mapping = [
        \ProfilePressVendor\Stripe\Collection::OBJECT_NAME => \ProfilePressVendor\Stripe\Collection::class,
        \ProfilePressVendor\Stripe\Issuing\CardDetails::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\CardDetails::class,
        \ProfilePressVendor\Stripe\SearchResult::OBJECT_NAME => \ProfilePressVendor\Stripe\SearchResult::class,
        \ProfilePressVendor\Stripe\File::OBJECT_NAME_ALT => \ProfilePressVendor\Stripe\File::class,
        // object classes: The beginning of the section generated from our OpenAPI spec
        \ProfilePressVendor\Stripe\Account::OBJECT_NAME => \ProfilePressVendor\Stripe\Account::class,
        \ProfilePressVendor\Stripe\AccountLink::OBJECT_NAME => \ProfilePressVendor\Stripe\AccountLink::class,
        \ProfilePressVendor\Stripe\AccountSession::OBJECT_NAME => \ProfilePressVendor\Stripe\AccountSession::class,
        \ProfilePressVendor\Stripe\ApplePayDomain::OBJECT_NAME => \ProfilePressVendor\Stripe\ApplePayDomain::class,
        \ProfilePressVendor\Stripe\Application::OBJECT_NAME => \ProfilePressVendor\Stripe\Application::class,
        \ProfilePressVendor\Stripe\ApplicationFee::OBJECT_NAME => \ProfilePressVendor\Stripe\ApplicationFee::class,
        \ProfilePressVendor\Stripe\ApplicationFeeRefund::OBJECT_NAME => \ProfilePressVendor\Stripe\ApplicationFeeRefund::class,
        \ProfilePressVendor\Stripe\Apps\Secret::OBJECT_NAME => \ProfilePressVendor\Stripe\Apps\Secret::class,
        \ProfilePressVendor\Stripe\Balance::OBJECT_NAME => \ProfilePressVendor\Stripe\Balance::class,
        \ProfilePressVendor\Stripe\BalanceTransaction::OBJECT_NAME => \ProfilePressVendor\Stripe\BalanceTransaction::class,
        \ProfilePressVendor\Stripe\BankAccount::OBJECT_NAME => \ProfilePressVendor\Stripe\BankAccount::class,
        \ProfilePressVendor\Stripe\Billing\Alert::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\Alert::class,
        \ProfilePressVendor\Stripe\Billing\AlertTriggered::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\AlertTriggered::class,
        \ProfilePressVendor\Stripe\Billing\CreditBalanceSummary::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\CreditBalanceSummary::class,
        \ProfilePressVendor\Stripe\Billing\CreditBalanceTransaction::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\CreditBalanceTransaction::class,
        \ProfilePressVendor\Stripe\Billing\CreditGrant::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\CreditGrant::class,
        \ProfilePressVendor\Stripe\Billing\Meter::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\Meter::class,
        \ProfilePressVendor\Stripe\Billing\MeterEvent::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\MeterEvent::class,
        \ProfilePressVendor\Stripe\Billing\MeterEventAdjustment::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\MeterEventAdjustment::class,
        \ProfilePressVendor\Stripe\Billing\MeterEventSummary::OBJECT_NAME => \ProfilePressVendor\Stripe\Billing\MeterEventSummary::class,
        \ProfilePressVendor\Stripe\BillingPortal\Configuration::OBJECT_NAME => \ProfilePressVendor\Stripe\BillingPortal\Configuration::class,
        \ProfilePressVendor\Stripe\BillingPortal\Session::OBJECT_NAME => \ProfilePressVendor\Stripe\BillingPortal\Session::class,
        \ProfilePressVendor\Stripe\Capability::OBJECT_NAME => \ProfilePressVendor\Stripe\Capability::class,
        \ProfilePressVendor\Stripe\Card::OBJECT_NAME => \ProfilePressVendor\Stripe\Card::class,
        \ProfilePressVendor\Stripe\CashBalance::OBJECT_NAME => \ProfilePressVendor\Stripe\CashBalance::class,
        \ProfilePressVendor\Stripe\Charge::OBJECT_NAME => \ProfilePressVendor\Stripe\Charge::class,
        \ProfilePressVendor\Stripe\Checkout\Session::OBJECT_NAME => \ProfilePressVendor\Stripe\Checkout\Session::class,
        \ProfilePressVendor\Stripe\Climate\Order::OBJECT_NAME => \ProfilePressVendor\Stripe\Climate\Order::class,
        \ProfilePressVendor\Stripe\Climate\Product::OBJECT_NAME => \ProfilePressVendor\Stripe\Climate\Product::class,
        \ProfilePressVendor\Stripe\Climate\Supplier::OBJECT_NAME => \ProfilePressVendor\Stripe\Climate\Supplier::class,
        \ProfilePressVendor\Stripe\ConfirmationToken::OBJECT_NAME => \ProfilePressVendor\Stripe\ConfirmationToken::class,
        \ProfilePressVendor\Stripe\ConnectCollectionTransfer::OBJECT_NAME => \ProfilePressVendor\Stripe\ConnectCollectionTransfer::class,
        \ProfilePressVendor\Stripe\CountrySpec::OBJECT_NAME => \ProfilePressVendor\Stripe\CountrySpec::class,
        \ProfilePressVendor\Stripe\Coupon::OBJECT_NAME => \ProfilePressVendor\Stripe\Coupon::class,
        \ProfilePressVendor\Stripe\CreditNote::OBJECT_NAME => \ProfilePressVendor\Stripe\CreditNote::class,
        \ProfilePressVendor\Stripe\CreditNoteLineItem::OBJECT_NAME => \ProfilePressVendor\Stripe\CreditNoteLineItem::class,
        \ProfilePressVendor\Stripe\Customer::OBJECT_NAME => \ProfilePressVendor\Stripe\Customer::class,
        \ProfilePressVendor\Stripe\CustomerBalanceTransaction::OBJECT_NAME => \ProfilePressVendor\Stripe\CustomerBalanceTransaction::class,
        \ProfilePressVendor\Stripe\CustomerCashBalanceTransaction::OBJECT_NAME => \ProfilePressVendor\Stripe\CustomerCashBalanceTransaction::class,
        \ProfilePressVendor\Stripe\CustomerSession::OBJECT_NAME => \ProfilePressVendor\Stripe\CustomerSession::class,
        \ProfilePressVendor\Stripe\Discount::OBJECT_NAME => \ProfilePressVendor\Stripe\Discount::class,
        \ProfilePressVendor\Stripe\Dispute::OBJECT_NAME => \ProfilePressVendor\Stripe\Dispute::class,
        \ProfilePressVendor\Stripe\Entitlements\ActiveEntitlement::OBJECT_NAME => \ProfilePressVendor\Stripe\Entitlements\ActiveEntitlement::class,
        \ProfilePressVendor\Stripe\Entitlements\ActiveEntitlementSummary::OBJECT_NAME => \ProfilePressVendor\Stripe\Entitlements\ActiveEntitlementSummary::class,
        \ProfilePressVendor\Stripe\Entitlements\Feature::OBJECT_NAME => \ProfilePressVendor\Stripe\Entitlements\Feature::class,
        \ProfilePressVendor\Stripe\EphemeralKey::OBJECT_NAME => \ProfilePressVendor\Stripe\EphemeralKey::class,
        \ProfilePressVendor\Stripe\Event::OBJECT_NAME => \ProfilePressVendor\Stripe\Event::class,
        \ProfilePressVendor\Stripe\ExchangeRate::OBJECT_NAME => \ProfilePressVendor\Stripe\ExchangeRate::class,
        \ProfilePressVendor\Stripe\File::OBJECT_NAME => \ProfilePressVendor\Stripe\File::class,
        \ProfilePressVendor\Stripe\FileLink::OBJECT_NAME => \ProfilePressVendor\Stripe\FileLink::class,
        \ProfilePressVendor\Stripe\FinancialConnections\Account::OBJECT_NAME => \ProfilePressVendor\Stripe\FinancialConnections\Account::class,
        \ProfilePressVendor\Stripe\FinancialConnections\AccountOwner::OBJECT_NAME => \ProfilePressVendor\Stripe\FinancialConnections\AccountOwner::class,
        \ProfilePressVendor\Stripe\FinancialConnections\AccountOwnership::OBJECT_NAME => \ProfilePressVendor\Stripe\FinancialConnections\AccountOwnership::class,
        \ProfilePressVendor\Stripe\FinancialConnections\Session::OBJECT_NAME => \ProfilePressVendor\Stripe\FinancialConnections\Session::class,
        \ProfilePressVendor\Stripe\FinancialConnections\Transaction::OBJECT_NAME => \ProfilePressVendor\Stripe\FinancialConnections\Transaction::class,
        \ProfilePressVendor\Stripe\Forwarding\Request::OBJECT_NAME => \ProfilePressVendor\Stripe\Forwarding\Request::class,
        \ProfilePressVendor\Stripe\FundingInstructions::OBJECT_NAME => \ProfilePressVendor\Stripe\FundingInstructions::class,
        \ProfilePressVendor\Stripe\Identity\VerificationReport::OBJECT_NAME => \ProfilePressVendor\Stripe\Identity\VerificationReport::class,
        \ProfilePressVendor\Stripe\Identity\VerificationSession::OBJECT_NAME => \ProfilePressVendor\Stripe\Identity\VerificationSession::class,
        \ProfilePressVendor\Stripe\Invoice::OBJECT_NAME => \ProfilePressVendor\Stripe\Invoice::class,
        \ProfilePressVendor\Stripe\InvoiceItem::OBJECT_NAME => \ProfilePressVendor\Stripe\InvoiceItem::class,
        \ProfilePressVendor\Stripe\InvoiceLineItem::OBJECT_NAME => \ProfilePressVendor\Stripe\InvoiceLineItem::class,
        \ProfilePressVendor\Stripe\InvoiceRenderingTemplate::OBJECT_NAME => \ProfilePressVendor\Stripe\InvoiceRenderingTemplate::class,
        \ProfilePressVendor\Stripe\Issuing\Authorization::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\Authorization::class,
        \ProfilePressVendor\Stripe\Issuing\Card::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\Card::class,
        \ProfilePressVendor\Stripe\Issuing\Cardholder::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\Cardholder::class,
        \ProfilePressVendor\Stripe\Issuing\Dispute::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\Dispute::class,
        \ProfilePressVendor\Stripe\Issuing\PersonalizationDesign::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\PersonalizationDesign::class,
        \ProfilePressVendor\Stripe\Issuing\PhysicalBundle::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\PhysicalBundle::class,
        \ProfilePressVendor\Stripe\Issuing\Token::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\Token::class,
        \ProfilePressVendor\Stripe\Issuing\Transaction::OBJECT_NAME => \ProfilePressVendor\Stripe\Issuing\Transaction::class,
        \ProfilePressVendor\Stripe\LineItem::OBJECT_NAME => \ProfilePressVendor\Stripe\LineItem::class,
        \ProfilePressVendor\Stripe\LoginLink::OBJECT_NAME => \ProfilePressVendor\Stripe\LoginLink::class,
        \ProfilePressVendor\Stripe\Mandate::OBJECT_NAME => \ProfilePressVendor\Stripe\Mandate::class,
        \ProfilePressVendor\Stripe\PaymentIntent::OBJECT_NAME => \ProfilePressVendor\Stripe\PaymentIntent::class,
        \ProfilePressVendor\Stripe\PaymentLink::OBJECT_NAME => \ProfilePressVendor\Stripe\PaymentLink::class,
        \ProfilePressVendor\Stripe\PaymentMethod::OBJECT_NAME => \ProfilePressVendor\Stripe\PaymentMethod::class,
        \ProfilePressVendor\Stripe\PaymentMethodConfiguration::OBJECT_NAME => \ProfilePressVendor\Stripe\PaymentMethodConfiguration::class,
        \ProfilePressVendor\Stripe\PaymentMethodDomain::OBJECT_NAME => \ProfilePressVendor\Stripe\PaymentMethodDomain::class,
        \ProfilePressVendor\Stripe\Payout::OBJECT_NAME => \ProfilePressVendor\Stripe\Payout::class,
        \ProfilePressVendor\Stripe\Person::OBJECT_NAME => \ProfilePressVendor\Stripe\Person::class,
        \ProfilePressVendor\Stripe\Plan::OBJECT_NAME => \ProfilePressVendor\Stripe\Plan::class,
        \ProfilePressVendor\Stripe\Price::OBJECT_NAME => \ProfilePressVendor\Stripe\Price::class,
        \ProfilePressVendor\Stripe\Product::OBJECT_NAME => \ProfilePressVendor\Stripe\Product::class,
        \ProfilePressVendor\Stripe\ProductFeature::OBJECT_NAME => \ProfilePressVendor\Stripe\ProductFeature::class,
        \ProfilePressVendor\Stripe\PromotionCode::OBJECT_NAME => \ProfilePressVendor\Stripe\PromotionCode::class,
        \ProfilePressVendor\Stripe\Quote::OBJECT_NAME => \ProfilePressVendor\Stripe\Quote::class,
        \ProfilePressVendor\Stripe\Radar\EarlyFraudWarning::OBJECT_NAME => \ProfilePressVendor\Stripe\Radar\EarlyFraudWarning::class,
        \ProfilePressVendor\Stripe\Radar\ValueList::OBJECT_NAME => \ProfilePressVendor\Stripe\Radar\ValueList::class,
        \ProfilePressVendor\Stripe\Radar\ValueListItem::OBJECT_NAME => \ProfilePressVendor\Stripe\Radar\ValueListItem::class,
        \ProfilePressVendor\Stripe\Refund::OBJECT_NAME => \ProfilePressVendor\Stripe\Refund::class,
        \ProfilePressVendor\Stripe\Reporting\ReportRun::OBJECT_NAME => \ProfilePressVendor\Stripe\Reporting\ReportRun::class,
        \ProfilePressVendor\Stripe\Reporting\ReportType::OBJECT_NAME => \ProfilePressVendor\Stripe\Reporting\ReportType::class,
        \ProfilePressVendor\Stripe\ReserveTransaction::OBJECT_NAME => \ProfilePressVendor\Stripe\ReserveTransaction::class,
        \ProfilePressVendor\Stripe\Review::OBJECT_NAME => \ProfilePressVendor\Stripe\Review::class,
        \ProfilePressVendor\Stripe\SetupAttempt::OBJECT_NAME => \ProfilePressVendor\Stripe\SetupAttempt::class,
        \ProfilePressVendor\Stripe\SetupIntent::OBJECT_NAME => \ProfilePressVendor\Stripe\SetupIntent::class,
        \ProfilePressVendor\Stripe\ShippingRate::OBJECT_NAME => \ProfilePressVendor\Stripe\ShippingRate::class,
        \ProfilePressVendor\Stripe\Sigma\ScheduledQueryRun::OBJECT_NAME => \ProfilePressVendor\Stripe\Sigma\ScheduledQueryRun::class,
        \ProfilePressVendor\Stripe\Source::OBJECT_NAME => \ProfilePressVendor\Stripe\Source::class,
        \ProfilePressVendor\Stripe\SourceMandateNotification::OBJECT_NAME => \ProfilePressVendor\Stripe\SourceMandateNotification::class,
        \ProfilePressVendor\Stripe\SourceTransaction::OBJECT_NAME => \ProfilePressVendor\Stripe\SourceTransaction::class,
        \ProfilePressVendor\Stripe\Subscription::OBJECT_NAME => \ProfilePressVendor\Stripe\Subscription::class,
        \ProfilePressVendor\Stripe\SubscriptionItem::OBJECT_NAME => \ProfilePressVendor\Stripe\SubscriptionItem::class,
        \ProfilePressVendor\Stripe\SubscriptionSchedule::OBJECT_NAME => \ProfilePressVendor\Stripe\SubscriptionSchedule::class,
        \ProfilePressVendor\Stripe\Tax\Calculation::OBJECT_NAME => \ProfilePressVendor\Stripe\Tax\Calculation::class,
        \ProfilePressVendor\Stripe\Tax\CalculationLineItem::OBJECT_NAME => \ProfilePressVendor\Stripe\Tax\CalculationLineItem::class,
        \ProfilePressVendor\Stripe\Tax\Registration::OBJECT_NAME => \ProfilePressVendor\Stripe\Tax\Registration::class,
        \ProfilePressVendor\Stripe\Tax\Settings::OBJECT_NAME => \ProfilePressVendor\Stripe\Tax\Settings::class,
        \ProfilePressVendor\Stripe\Tax\Transaction::OBJECT_NAME => \ProfilePressVendor\Stripe\Tax\Transaction::class,
        \ProfilePressVendor\Stripe\Tax\TransactionLineItem::OBJECT_NAME => \ProfilePressVendor\Stripe\Tax\TransactionLineItem::class,
        \ProfilePressVendor\Stripe\TaxCode::OBJECT_NAME => \ProfilePressVendor\Stripe\TaxCode::class,
        \ProfilePressVendor\Stripe\TaxDeductedAtSource::OBJECT_NAME => \ProfilePressVendor\Stripe\TaxDeductedAtSource::class,
        \ProfilePressVendor\Stripe\TaxId::OBJECT_NAME => \ProfilePressVendor\Stripe\TaxId::class,
        \ProfilePressVendor\Stripe\TaxRate::OBJECT_NAME => \ProfilePressVendor\Stripe\TaxRate::class,
        \ProfilePressVendor\Stripe\Terminal\Configuration::OBJECT_NAME => \ProfilePressVendor\Stripe\Terminal\Configuration::class,
        \ProfilePressVendor\Stripe\Terminal\ConnectionToken::OBJECT_NAME => \ProfilePressVendor\Stripe\Terminal\ConnectionToken::class,
        \ProfilePressVendor\Stripe\Terminal\Location::OBJECT_NAME => \ProfilePressVendor\Stripe\Terminal\Location::class,
        \ProfilePressVendor\Stripe\Terminal\Reader::OBJECT_NAME => \ProfilePressVendor\Stripe\Terminal\Reader::class,
        \ProfilePressVendor\Stripe\TestHelpers\TestClock::OBJECT_NAME => \ProfilePressVendor\Stripe\TestHelpers\TestClock::class,
        \ProfilePressVendor\Stripe\Token::OBJECT_NAME => \ProfilePressVendor\Stripe\Token::class,
        \ProfilePressVendor\Stripe\Topup::OBJECT_NAME => \ProfilePressVendor\Stripe\Topup::class,
        \ProfilePressVendor\Stripe\Transfer::OBJECT_NAME => \ProfilePressVendor\Stripe\Transfer::class,
        \ProfilePressVendor\Stripe\TransferReversal::OBJECT_NAME => \ProfilePressVendor\Stripe\TransferReversal::class,
        \ProfilePressVendor\Stripe\Treasury\CreditReversal::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\CreditReversal::class,
        \ProfilePressVendor\Stripe\Treasury\DebitReversal::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\DebitReversal::class,
        \ProfilePressVendor\Stripe\Treasury\FinancialAccount::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\FinancialAccount::class,
        \ProfilePressVendor\Stripe\Treasury\FinancialAccountFeatures::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\FinancialAccountFeatures::class,
        \ProfilePressVendor\Stripe\Treasury\InboundTransfer::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\InboundTransfer::class,
        \ProfilePressVendor\Stripe\Treasury\OutboundPayment::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\OutboundPayment::class,
        \ProfilePressVendor\Stripe\Treasury\OutboundTransfer::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\OutboundTransfer::class,
        \ProfilePressVendor\Stripe\Treasury\ReceivedCredit::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\ReceivedCredit::class,
        \ProfilePressVendor\Stripe\Treasury\ReceivedDebit::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\ReceivedDebit::class,
        \ProfilePressVendor\Stripe\Treasury\Transaction::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\Transaction::class,
        \ProfilePressVendor\Stripe\Treasury\TransactionEntry::OBJECT_NAME => \ProfilePressVendor\Stripe\Treasury\TransactionEntry::class,
        \ProfilePressVendor\Stripe\UsageRecord::OBJECT_NAME => \ProfilePressVendor\Stripe\UsageRecord::class,
        \ProfilePressVendor\Stripe\UsageRecordSummary::OBJECT_NAME => \ProfilePressVendor\Stripe\UsageRecordSummary::class,
        \ProfilePressVendor\Stripe\WebhookEndpoint::OBJECT_NAME => \ProfilePressVendor\Stripe\WebhookEndpoint::class,
    ];
    /**
     * @var array Mapping from v2 object types to resource classes
     */
    const v2Mapping = [
        // v2 object classes: The beginning of the section generated from our OpenAPI spec
        \ProfilePressVendor\Stripe\V2\Billing\MeterEvent::OBJECT_NAME => \ProfilePressVendor\Stripe\V2\Billing\MeterEvent::class,
        \ProfilePressVendor\Stripe\V2\Billing\MeterEventAdjustment::OBJECT_NAME => \ProfilePressVendor\Stripe\V2\Billing\MeterEventAdjustment::class,
        \ProfilePressVendor\Stripe\V2\Billing\MeterEventSession::OBJECT_NAME => \ProfilePressVendor\Stripe\V2\Billing\MeterEventSession::class,
        \ProfilePressVendor\Stripe\V2\Event::OBJECT_NAME => \ProfilePressVendor\Stripe\V2\Event::class,
        \ProfilePressVendor\Stripe\V2\EventDestination::OBJECT_NAME => \ProfilePressVendor\Stripe\V2\EventDestination::class,
    ];
}
