<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'box_id' => array(
		'type'    => 'box',
		'title'   => esc_html__( 'Options for child categories', 'enginx' ),
		'options' => array(
			'layout'        => array(
				'label'   => esc_html__( 'Portfolio Layout', 'enginx' ),
				'desc'    => esc_html__( 'Choose projects layout', 'enginx' ),
				'value'   => 'isotope',
				'type'    => 'select',
				'choices' => array(
					'carousel' => esc_html__( 'Carousel', 'enginx' ),
					'isotope'  => esc_html__( 'Masonry Grid', 'enginx' ),
				)
			),
			'item_layout'   => array(
				'label'   => esc_html__( 'Item layout', 'enginx' ),
				'desc'    => esc_html__( 'Choose Item layout', 'enginx' ),
				'value'   => 'item-regular',
				'type'    => 'select',
				'choices' => array(
					'item-regular'  => esc_html__( 'Regular (just image)', 'enginx' ),
					'item-title'    => esc_html__( 'Image with title', 'enginx' ),
					'item-extended' => esc_html__( 'Image with title and excerpt', 'enginx' ),
				)
			),
			'full_width'    => array(
				'type'         => 'switch',
				'value'        => false,
				'label'        => esc_html__( 'Full width gallery', 'enginx' ),
				'desc'         => esc_html__( 'Enable full width container for gallery', 'enginx' ),
				'left-choice'  => array(
					'value' => false,
					'label' => esc_html__( 'No', 'enginx' ),
				),
				'right-choice' => array(
					'value' => true,
					'label' => esc_html__( 'Yes', 'enginx' ),
				),
			),
			'margin'        => array(
				'label'   => esc_html__( 'Horizontal item margin (px)', 'enginx' ),
				'desc'    => esc_html__( 'Select horizontal item margin', 'enginx' ),
				'value'   => '30',
				'type'    => 'select',
				'choices' => array(
					'0'  => esc_html__( '0', 'enginx' ),
					'1'  => esc_html__( '1px', 'enginx' ),
					'2'  => esc_html__( '2px', 'enginx' ),
					'10' => esc_html__( '10px', 'enginx' ),
					'30' => esc_html__( '30px', 'enginx' ),
				)
			),
			'responsive_lg' => array(
				'label'   => esc_html__( 'Columns on large screens', 'enginx' ),
				'desc'    => esc_html__( 'Select items number on wide screens (>1200px)', 'enginx' ),
				'value'   => '4',
				'type'    => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'enginx' ),
					'2' => esc_html__( '2', 'enginx' ),
					'3' => esc_html__( '3', 'enginx' ),
					'4' => esc_html__( '4', 'enginx' ),
					'6' => esc_html__( '6', 'enginx' ),
				)
			),
			'responsive_md' => array(
				'label'   => esc_html__( 'Columns on middle screens', 'enginx' ),
				'desc'    => esc_html__( 'Select items number on middle screens (>992px)', 'enginx' ),
				'value'   => '3',
				'type'    => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'enginx' ),
					'2' => esc_html__( '2', 'enginx' ),
					'3' => esc_html__( '3', 'enginx' ),
					'4' => esc_html__( '4', 'enginx' ),
					'6' => esc_html__( '6', 'enginx' ),
				)
			),
			'responsive_sm' => array(
				'label'   => esc_html__( 'Columns on small screens', 'enginx' ),
				'desc'    => esc_html__( 'Select items number on small screens (>768px)', 'enginx' ),
				'value'   => '2',
				'type'    => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'enginx' ),
					'2' => esc_html__( '2', 'enginx' ),
					'3' => esc_html__( '3', 'enginx' ),
					'4' => esc_html__( '4', 'enginx' ),
					'6' => esc_html__( '6', 'enginx' ),
				)
			),
			'responsive_xs' => array(
				'label'   => esc_html__( 'Columns on extra small screens', 'enginx' ),
				'desc'    => esc_html__( 'Select items number on extra small screens (<767px)', 'enginx' ),
				'value'   => '1',
				'type'    => 'select',
				'choices' => array(
					'1' => esc_html__( '1', 'enginx' ),
					'2' => esc_html__( '2', 'enginx' ),
					'3' => esc_html__( '3', 'enginx' ),
					'4' => esc_html__( '4', 'enginx' ),
					'6' => esc_html__( '6', 'enginx' ),
				)
			),
			'show_filters'  => array(
				'type'         => 'switch',
				'value'        => false,
				'label'        => esc_html__( 'Show filters', 'enginx' ),
				'desc'         => esc_html__( 'Hide or show categories filters', 'enginx' ),
				'left-choice'  => array(
					'value' => false,
					'label' => esc_html__( 'No', 'enginx' ),
				),
				'right-choice' => array(
					'value' => true,
					'label' => esc_html__( 'Yes', 'enginx' ),
				),
			),
			'items_per_page' => array(
				'type'  => 'select',
				'value' => '12',
				'label' => esc_html__( 'Items Per Page', 'enginx' ),
				'choices' => array(
					'2' =>  esc_html__('2 Items', 'enginx'),
					'3' =>  esc_html__('3 Items', 'enginx'),
					'4' =>  esc_html__('4 Items', 'enginx'),
					'6' =>  esc_html__('6 Items', 'enginx'),
					'8' =>  esc_html__('8 Items', 'enginx'),
					'9' =>  esc_html__('9 Items', 'enginx'),
					'12' =>  esc_html__('12 Items', 'enginx'),
					'16' =>  esc_html__('16 Items', 'enginx'),
				),
			)

		)
	)
);