<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * @var string $before_widget
 * @var string $after_widget
 * @var array $popular_posts
 */
$unique_id = uniqid();

if ( $r->have_posts() ) :
	?>
	<?php echo wp_kses_post($args['before_widget']); ?>
	<?php if ( $title ) {
	echo wp_kses_post($args['before_title'] . $title . $args['after_title']);
} ?>
	<ul id="recent_posts_<?php echo esc_attr( $unique_id ); ?>" class="list-unstyled">
		<?php while ( $r->have_posts() ) : $r->the_post(); ?>
			<li <?php post_class( 'media align-items-center' ); ?>>
				<?php if ( has_post_thumbnail() ) : ?>
					<a href="<?php the_permalink(); ?>" class="media-left">
						<?php echo get_the_post_thumbnail( get_the_ID(), 'thumbnail' ); ?>
					</a>
				<?php endif; //has_post_thumbnail ?>
				<div class="media-body">
					<h4><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>
					<div class="item-meta">
						<span class="widget-post-date links-grey">
							<?php
							if (function_exists('enginx_the_date') ) :
							enginx_the_date( array(
								'before' => '<span><i class="mr-2 fs-14 color-main ico-clock-alt"></i>',
								'after' => '</span>',
								'link_attributes' => 'rel="bookmark"',
								'time_tag_class' => 'entry-date',
								'days_ago' => true
							) );
							endif; ?>
						</span>
					</div>
				</div>
			</li>
		<?php endwhile; ?>
	</ul>
	<?php echo wp_kses_post($args['after_widget']); ?>
	<?php
	// Reset the global $the_post as this query will have stomped on it
	wp_reset_postdata();

endif;
?>
