<?php
/**
 * The default template for displaying content
 *
 * Used for index/archive.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$share_buttons_classes = function_exists( 'mwt_share_this' ) && enginx_is_share_buttons_active() ? 'post-share-buttons' : '';

$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item content-padding post-padding bordered ' . $share_buttons_classes ); ?>>
	<?php enginx_post_thumbnail('','',''); ?>
	<?php
	if( $share_buttons_classes ) {
		enginx_share_this();
	}
	?>
	<div class="item-content">
		<header class="entry-header">
			<?php
			the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			?>

		</header><!-- .entry-header -->
		<?php if ( ! empty( get_the_tags() ) && !enginx_get_option( 'blog_hide_tags' ) ) : ?>
			<div class="tagcloud sticky-tags d-block">
				<?php the_tags( '', '', '' ); ?>
			</div>
		<?php endif; ?>
		<div class="entry-content">
			<?php
			//hidding "more link" in content
			the_content( esc_html__( 'Read More', 'enginx' ) );
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'enginx' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
			) );
			?>
		</div><!-- eof .entry-content -->
		<div class="entry-meta post-meta">

			<?php
			if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && enginx_categorized_blog() &&  ! enginx_get_option( 'blog_hide_categories' ) ) :
				enginx_the_categories();
			endif; //categories
			if ( 'post' == get_post_type() ) :
				enginx_posted_on();

				enginx_comments_counter(
					array(
						'before' => '<span class="comments-link links-darkgrey pull-right"><i class="ico-comments-alt mr-2 color-main"></i>',
						'after' => '</span>',
						'password_protected' => false,
						'comments_are_closed' => false,
					)
				);

			endif; //'post' == get_post_type() ?>
		</div><!-- .entry-meta -->
	</div><!-- eof .item-content -->
</article><!-- #post-## -->
