<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

/**
 * @var $atts The shortcode attributes
 */
$show_button = ( ! empty( $link ) && ! empty( $atts['button']['show_button'] ) && ! empty( $atts['button']['button']['label'] ) ) ? true : false;

switch ( $atts['layout'] ) :
	case '2':
?>
<div class="pricing-plan cs plan2 <?php echo esc_attr( $atts['featured'] ); ?>">
	<?php if( ! empty( $atts['title'] ) ) : ?>
		<div class="plan-name">
			<h4 class="text-uppercase">
				<?php echo wp_kses_post( $atts['title'] ); ?>
			</h4>
		</div>
	<?php endif; ?>
	<div class="price-wrap">
		<?php if( ! empty( $atts['price_after'] ) ) : ?>
			<h6 class="fw-300 text-uppercase"><?php echo wp_kses_post( $atts['price_after'] ); ?></h6>
		<?php endif; ?>
		<?php if( ! empty( $atts['currency'] ) ) : ?>
			<span class="plan-sign"><?php echo wp_kses_post( $atts['currency'] ); ?></span>
		<?php endif; ?>
		<?php if( ! empty( $atts['price'] ) ) : ?>
			<span class="plan-price"><?php echo wp_kses_post( $atts['price'] ); ?></span>
		<?php endif; ?>
	</div>
	<?php if( ! empty( $atts['description'] ) ) : ?>
		<div class="plan-description">
			<?php echo wp_kses_post( $atts['description'] ); ?>
		</div>
	<?php endif; ?>
	<?php if( ! empty( $atts['features'] ) ) : ?>
		<div class="plan-features fw-400">
			<ul>
				<?php foreach( ( $atts['features'] ) as $feature ) : ?>
					<li>
						<div class="icon-inline">
							<?php if ( $feature['price_icon'] ): ?>
								<div class="icon-styled">
									<i class="<?php echo esc_attr( $feature['price_icon']  ); ?> fs-12 fw-900"></i>
								</div>
							<?php endif; //icon
							?>
							<p>
								<?php echo wp_kses_post( $feature['feature_name'] ); ?>
							</p>
						</div>

					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
	<?php if ( !empty( $atts['price_buttons'] ) ) : ?>
		<?php foreach( $atts['price_buttons'] as $button ) : ?>
			<?php echo fw()->extensions->get('shortcodes')->get_shortcode('button')->render($button); ?>
		<?php endforeach; ?>
	<?php endif; ?>
</div>
<?php
//2
break;
case '4':
?>
<div class="pricing-plan cs plan4 <?php echo esc_attr( $atts['featured'] ); ?>">
	<?php if( ! empty( $atts['title'] ) ) : ?>
		<div class="plan-name">
			<h4 class="text-uppercase">
				<?php echo wp_kses_post( $atts['title'] ); ?>
			</h4>
		</div>
	<?php endif; ?>
	<div class="price-wrap">
		<?php if( ! empty( $atts['price_after'] ) ) : ?>
			<h6 class="fw-300 text-uppercase"><?php echo wp_kses_post( $atts['price_after'] ); ?></h6>
		<?php endif; ?>
		<?php if( ! empty( $atts['currency'] ) ) : ?>
			<span class="plan-sign"><?php echo wp_kses_post( $atts['currency'] ); ?></span>
		<?php endif; ?>
		<?php if( ! empty( $atts['price'] ) ) : ?>
			<span class="plan-price"><?php echo wp_kses_post( $atts['price'] ); ?></span>
		<?php endif; ?>
	</div>
	<?php if( ! empty( $atts['description'] ) ) : ?>
		<div class="plan-description">
			<?php echo wp_kses_post( $atts['description'] ); ?>
		</div>
	<?php endif; ?>
	<?php if( ! empty( $atts['features'] ) ) : ?>
		<div class="plan-features fw-400">
			<ul>
				<?php foreach( ( $atts['features'] ) as $feature ) : ?>
					<li>
						<div class="icon-inline">
							<?php if ( $feature['price_icon'] ): ?>
								<div class="icon-styled">
									<i class="<?php echo esc_attr( $feature['price_icon']  ); ?> fs-12 fw-900"></i>
								</div>
							<?php endif; //icon
							?>
							<p>
								<?php echo wp_kses_post( $feature['feature_name'] ); ?>
							</p>
						</div>

					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
	<?php if ( !empty( $atts['price_buttons'] ) ) : ?>
		<?php foreach( $atts['price_buttons'] as $button ) : ?>
			<?php echo fw()->extensions->get('shortcodes')->get_shortcode('button')->render($button); ?>
		<?php endforeach; ?>
	<?php endif; ?>
</div>
<?php
//4
break;
case '3':
?>
<div class="pricing-plan cs plan3 <?php echo esc_attr( $atts['featured'] ); ?>">
	<?php if( ! empty( $atts['title'] ) ) : ?>
		<div class="plan-name">
			<h4 class="text-uppercase">
				<?php echo wp_kses_post( $atts['title'] ); ?>
			</h4>
		</div>
	<?php endif; ?>
	<div class="price-wrap">
		<?php if( ! empty( $atts['price_after'] ) ) : ?>
			<h6 class="fw-300 text-uppercase"><?php echo wp_kses_post( $atts['price_after'] ); ?></h6>
		<?php endif; ?>
		<?php if( ! empty( $atts['currency'] ) ) : ?>
			<span class="plan-sign"><?php echo wp_kses_post( $atts['currency'] ); ?></span>
		<?php endif; ?>
		<?php if( ! empty( $atts['price'] ) ) : ?>
			<span class="plan-price"><?php echo wp_kses_post( $atts['price'] ); ?></span>
		<?php endif; ?>

	</div>
	<?php if( ! empty( $atts['description'] ) ) : ?>
		<div class="plan-description">
			<?php echo wp_kses_post( $atts['description'] ); ?>
		</div>
	<?php endif; ?>
	<?php if( ! empty( $atts['features'] ) ) : ?>
		<div class="plan-features fw-400">
			<ul>
				<?php foreach( ( $atts['features'] ) as $feature ) : ?>
					<li>
						<div class="icon-inline">
							<?php if ( $feature['price_icon'] ): ?>
								<div class="icon-styled">
									<i class="<?php echo esc_attr( $feature['price_icon']  ); ?> fs-12 fw-900"></i>
								</div>
							<?php endif; //icon
							?>
							<p>
								<?php echo wp_kses_post( $feature['feature_name'] ); ?>
							</p>
						</div>

					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
	<?php if ( !empty( $atts['price_buttons'] ) ) : ?>
		<?php foreach( $atts['price_buttons'] as $button ) : ?>
			<?php echo fw()->extensions->get('shortcodes')->get_shortcode('button')->render($button); ?>
		<?php endforeach; ?>
	<?php endif; ?>
</div>
<?php
//3
break;
default:
?>
<div class="pricing-plan cs plan1 <?php echo esc_attr( $atts['featured'] ); ?>">
	<?php if( ! empty( $atts['title'] ) ) : ?>
		<div class="plan-name">
			<h4 class="text-uppercase">
				<?php echo wp_kses_post( $atts['title'] ); ?>
			</h4>
		</div>
	<?php endif; ?>
	<?php if( ! empty( $atts['price_after'] ) ) : ?>
	<?php endif; ?>
	<div class="price-wrap">
		<h6 class="fw-300 text-uppercase"><?php echo wp_kses_post( $atts['price_after'] ); ?></h6>
		<?php if( ! empty( $atts['currency'] ) ) : ?>
			<span class="plan-sign"><?php echo wp_kses_post( $atts['currency'] ); ?></span>
		<?php endif; ?>
		<?php if( ! empty( $atts['price'] ) ) : ?>
			<span class="plan-price"><?php echo wp_kses_post( $atts['price'] ); ?></span>
		<?php endif; ?>

	</div>
	<?php if( ! empty( $atts['description'] ) ) : ?>
		<div class="plan-description">
			<?php echo wp_kses_post( $atts['description'] ); ?>
		</div>
	<?php endif; ?>
	<?php if( ! empty( $atts['features'] ) ) : ?>
		<div class="plan-features fw-400">
			<ul>
				<?php foreach( ( $atts['features'] ) as $feature ) : ?>
					<li>
						<div class="icon-inline">
							<?php if ( $feature['price_icon'] ): ?>
								<div class="icon-styled">
									<i class="<?php echo esc_attr( $feature['price_icon']  ); ?> fs-12 fw-900"></i>
								</div>
							<?php endif; //icon
							?>
							<p>
								<?php echo wp_kses_post( $feature['feature_name'] ); ?>
							</p>
						</div>

					</li>
				<?php endforeach; ?>
			</ul>
		</div>
	<?php endif; ?>
	<?php if ( !empty( $atts['price_buttons'] ) ) : ?>
		<?php foreach( $atts['price_buttons'] as $button ) : ?>
			<?php echo fw()->extensions->get('shortcodes')->get_shortcode('button')->render($button); ?>
		<?php endforeach; ?>
	<?php endif; ?>
</div>
<?php endswitch;