<?php
/**
 * The default template for displaying content
 *
 * Used for index/archive.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$show_post_thumbnail = ( post_password_required()
						 || is_attachment()
                         || ! has_post_thumbnail() ) ? false : true;
$image_wrap_class    = $show_post_thumbnail
	? 'col-xl-6 col-lg-6 col-md-6 col-xs-12 col-12' : '';
$content_wrap_class  = $show_post_thumbnail
	? 'col-xl-6 col-lg-6 col-md-6 col-xs-12 col-12' : 'col-12';
?>
<article
		id="post-<?php the_ID(); ?>" <?php post_class( 'side-item no-content-padding' ); ?>>
	<div class="row">
		<?php enginx_post_thumbnail( 'col-xl-6 col-lg-6 col-md-6 col-xs-12 col-12' ); ?>

		<div class="<?php echo esc_attr( $content_wrap_class ); ?>">
			<div class="item-content entry-content">
				<header class="entry-header">
				<?php the_title( '<h4 class="entry-title"><a href="'. esc_url( get_permalink() ). '" rel="bookmark">', '</a></h4>' );?>
					<div class="entry-meta post-meta">

						<?php
						if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && enginx_categorized_blog() &&  ! enginx_get_option( 'blog_hide_categories' ) ) :
							enginx_the_categories();
						endif; //categories
						if ( 'post' == get_post_type() ) :
							enginx_posted_on();

							enginx_comments_counter(
								array(
									'before' => '<span class="comments-link links-darkgrey pull-right"><i class="ico-comments-alt mr-2 color-main"></i>',
									'after' => '</span>',
									'password_protected' => false,
									'comments_are_closed' => false,
								)
							);

						endif; //'post' == get_post_type() ?>
					</div><!-- .entry-meta -->
				</header><!-- .entry-header -->
				<div class="entry-content">
					<?php
					//hidding "more link" in content
					the_content( esc_html__( 'Read More', 'enginx' ) );
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'enginx' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					) );
					?>
				</div><!-- eof .entry-content -->
			</div><!-- eof .item-content -->
		</div><!-- .col -->
	</div><!-- .row -->
</article><!-- #post-## -->
