	<?php
	/**
	* The default template for displaying content
	*
	* Used for index/archive.
	*/

	if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
	}

	$show_post_thumbnail = ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) ? false : true;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'vertical-item grid-padding content-padding hero-bg ' ); ?>>
	<?php enginx_post_thumbnail(); ?>
	<div class="item-content entry-content">

		<header class="entry-header">
			<?php if ( ! empty( get_the_tags() ) && !enginx_get_option( 'blog_hide_tags' ) ) : ?>
				<div class="tagcloud sticky-tags d-block">
					<?php the_tags( '', '', '' ); ?>
				</div>
			<?php endif; ?>
			<?php the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' ); ?>

		</header><!-- .entry-header -->

		<div class="entry-content">
			<?php the_excerpt();?>
			<div class="entry-meta post-meta">
				<?php
				if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) && enginx_categorized_blog() &&  ! enginx_get_option( 'blog_hide_categories' ) ) :
					enginx_the_categories();
				endif; //categories
				if ( 'post' == get_post_type() ) :
					enginx_posted_on();

					enginx_comments_counter(
						array(
							'before' => '<span class="comments-link links-darkgrey pull-right">',
							'after' => '</span>',
							'password_protected' => false,
							'comments_are_closed' => false,
						)
					);

				endif; //'post' == get_post_type() ?>
			</div><!-- .entry-meta -->
		</div><!-- .entry-content -->

	</div><!-- eof .item-content -->
</article><!-- #post-## -->
