<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}


// share buttons
if ( ! function_exists( 'mwt_share_this' ) ) :
	/**
	 * Share article through social networks.
	 * bool $only_buttons
	 */
	function mwt_share_this( $only_buttons = false ) {

		$share_buttons                      = array();
		$share_buttons['share_telegram']    = '<span><a href="https://telegram.me/share/url?url=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-paper-plane" target="_blank"></a></span>';
		$share_buttons['share_facebook']    = '<span><a href="https://www.facebook.com/sharer.php?u=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-facebook" target="_blank"></a></span>';
		$share_buttons['share_twitter']     = '<span><a href="https://twitter.com/intent/tweet?url=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-twitter" target="_blank"></a></span>';
		$share_buttons['share_google_plus'] = '<span><a href="https://plus.google.com/share?url=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-google" target="_blank"></a></span>';
		$share_buttons['share_pinterest']   = '<span><a href="https://pinterest.com/pin/create/bookmarklet/?url=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-pinterest" target="_blank"></a></span>';
		$share_buttons['share_linkedin']    = '<span><a href="https://www.linkedin.com/shareArticle?url=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-linkedin" target="_blank"></a></span>';
		$share_buttons['share_tumblr']      = '<span><a href="https://www.tumblr.com/widgets/share/tool?canonicalUrl=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-tumblr" target="_blank"></a></span>';
		$share_buttons['share_reddit']      = '<span><a href="https://reddit.com/submit?url=' . esc_url( get_permalink() ) . '" class="color-icon border-icon rounded-icon fa fa-reddit" target="_blank"></a></span>';
		if ( function_exists( 'fw_get_db_customizer_option' ) ) {
			if ( ! fw_get_db_customizer_option( 'share_telegram' ) ) {
				unset( $share_buttons['share_telegram'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_facebook' ) ) {
				unset( $share_buttons['share_facebook'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_twitter' ) ) {
				unset( $share_buttons['share_twitter'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_google_plus' ) ) {
				unset( $share_buttons['share_google_plus'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_pinterest' ) ) {
				unset( $share_buttons['share_pinterest'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_linkedin' ) ) {
				unset( $share_buttons['share_linkedin'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_tumblr' ) ) {
				unset( $share_buttons['share_tumblr'] );
			}

			if ( ! fw_get_db_customizer_option( 'share_reddit' ) ) {
				unset( $share_buttons['share_reddit'] );
			}
		}

		if ( ! empty ( $share_buttons ) ) :
			$unique_id = uniqid();

			if ( ! $only_buttons ) : ?>

			<?php endif; //only_buttons ?>
			<div class="share_buttons">
				<?php
				foreach ( $share_buttons as $share_button ) :
					echo wp_kses_post( $share_button );
				endforeach;
				?>
			</div><!-- eof .share_buttons -->
			<?php if ( ! $only_buttons ) : ?>
		<?php endif; //only_buttons
		endif; // share_buttons
	} //mwt_share_this()
endif; //function_exists