<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$options = enginx_get_options();
$section = enginx_get_section_options( $options, 'topline_' );

if( $options['page_header'] == 2 ) {
    $section['section_class'] .= ' d-xl-none';
}

?>
<section class="page_topline c-my-5 <?php echo esc_attr( $section['section_class'] ); ?>"
	<?php echo ( !empty( $section['section_id'] ) ) ? 'id="'. esc_attr( $section['section_id'] ) . '"' : ''; ?>
	<?php echo ( !empty( $section['section_background_image'] ) ) ? 'style="'. esc_attr( $section['section_background_image'] ) . '"' : ''; ?>
>
	<div class="particles-js" id="<?php echo esc_attr( uniqid('par-') ); ?>"></div>
	<div class="container<?php echo esc_attr( $section['section_container_class_suffix'] ); ?>">
		<div class="row align-items-center">
			<div class="col-8">
				<?php
					if ( !empty ( $options['social_icons'] ) && !empty ( $options['fw'] ) ) :
				?>
				<span class="social-icons">
				<?php
					//get icons-social shortcode to render icons in team member item
					$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
					if ( ! empty( $shortcodes_extension ) ) :
						echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $options['social_icons'] ) );
					endif; //
					?>
				</span>
				<?php endif; //social_icons ?>
			</div>
			<div class="col-4 text-right">
				<!--modal search-->
				<span>
					<a href="#" class="search_modal_button">
						<i class="fa fa-search"></i>
					</a>
				</span>
			</div>
		</div>
	</div>
</section><!-- .page_topline -->