<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'main' => array(
		'type'    => 'box',
		'title'   => '',
		'options' => array(
			'id'       => array(
				'type' => 'unique',
			),
			'builder'  => array(
				'type'    => 'tab',
				'title'   => esc_html__( 'Form Fields', 'enginx' ),
				'options' => array(
					'form' => array(
						'label'        => false,
						'type'         => 'form-builder',
						'value'        => array(
							'json' => apply_filters( 'fw:ext:forms:builder:load-item:form-header-title', true )
								? json_encode( array(
									array(
										'type'      => 'form-header-title',
										'shortcode' => 'form_header_title',
										'width'     => '',
										'options'   => array(
											'title'    => '',
											'subtitle' => '',
										)
									)
								) )
								: '[]'
						),
						'fixed_header' => true,
					),
				),
			),
			'settings' => array(
				'type'    => 'tab',
				'title'   => esc_html__( 'Settings', 'enginx' ),
				'options' => array(
					'settings-options' => array(
						'title'   => esc_html__( 'Contact Form Options', 'enginx' ),
						'type'    => 'tab',
						'options' => array(
							'background_color'    => array(
								'type'    => 'select',
								'value'   => 'ls',
								'label'   => esc_html__( 'Form Background color', 'enginx' ),
								'desc'    => esc_html__( 'Select background color', 'enginx' ),
								'help'    => esc_html__( 'Select one of predefined background colors', 'enginx' ),
								'choices' => array(
									''                              => esc_html__( 'No background', 'enginx' ),
									'p-40 muted-bg' => esc_html__( 'Muted', 'enginx' ),
									'p-40 bordered'      => esc_html__( 'With Border', 'enginx' ),
									'p-40 ls'               => esc_html__( 'Light', 'enginx' ),
									'p-40 ls ms'            => esc_html__( 'Light Grey', 'enginx' ),
									'p-40 ds'               => esc_html__( 'Dark Grey', 'enginx' ),
									'p-40 ds ms'            => esc_html__( 'Dark', 'enginx' ),
									'p-40 cs'               => esc_html__( 'Main color', 'enginx' ),
									'p-40 cs cs2'   => esc_html__( 'Second Main color', 'enginx' ),
								),
							),
							'columns_padding'     => array(
								'type'    => 'select',
								'value'   => 'c-gutter-30',
								'label'   => esc_html__( 'Columns gutter', 'enginx' ),
								'desc'    => esc_html__( 'Choose columns horizontal padding (gutter) value inside form', 'enginx' ),
								'choices' => array(
									'c-gutter-30' => esc_html__( '30px - default', 'enginx' ),
									'c-gutter-10'  => esc_html__( '10px', 'enginx' ),
									'c-gutter-20'  => esc_html__( '20px', 'enginx' ),
									'c-gutter-40'  => esc_html__( '40px', 'enginx' ),
									'c-gutter-50'  => esc_html__( '50px', 'enginx' ),
									'c-gutter-60'  => esc_html__( '60px', 'enginx' ),
								),
							),
							'columns_margin_bottom'     => array(
								'type'    => 'select',
								'value'   => 'c-mb-15',
								'label'   => esc_html__( 'Columns bottom margins', 'enginx' ),
								'desc'    => esc_html__( 'Choose columns bottom margin value inside form', 'enginx' ),
								'choices' => array(
									'c-mb-15' => esc_html__( '15px - default', 'enginx' ),
									'c-mb-5'  => esc_html__( '5px', 'enginx' ),
									'c-mb-10'  => esc_html__( '10px', 'enginx' ),
									'c-mb-20'  => esc_html__( '20px', 'enginx' ),
									'c-mb-25'  => esc_html__( '25px', 'enginx' ),
									'c-mb-30'  => esc_html__( '30px', 'enginx' ),
								),
							),
							'form_email_settings' => array(
								'type'    => 'group',
								'options' => array(
									'email_to' => array(
										'type'  => 'text',
										'label' => esc_html__( 'Email To', 'enginx' ),
										'help'  => esc_html__( 'We recommend you to use an email that you verify often', 'enginx' ),
										'desc'  => esc_html__( 'The form will be sent to this email address.', 'enginx' ),
									),
								),
							),
							'form_text_settings'  => array(
								'type'    => 'group',
								'options' => array(
									'subject-group'       => array(
										'type'    => 'group',
										'options' => array(
											'subject_message' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Subject Message', 'enginx' ),
												'desc'  => esc_html__( 'This text will be used as subject message for the email', 'enginx' ),
												'value' => esc_html__( 'Contact Form', 'enginx' ),
											),
										)
									),
									'submit-button-group' => array(
										'type'    => 'group',
										'options' => array(
											'submit_button_text' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Submit Button', 'enginx' ),
												'desc'  => esc_html__( 'This text will appear in submit button', 'enginx' ),
												'value' => esc_html__( 'Send', 'enginx' ),
											),
											'reset_button_text'  => array(
												'type'  => 'text',
												'label' => esc_html__( 'Reset Button', 'enginx' ),
												'desc'  => esc_html__( 'This text will appear in reset button. Leave blank if reset button not needed', 'enginx' ),
												'value' => esc_html__( 'Clear', 'enginx' ),
											),
										)
									),
									'success-group'       => array(
										'type'    => 'group',
										'options' => array(
											'success_message' => array(
												'type'  => 'text',
												'label' => esc_html__( 'Success Message', 'enginx' ),
												'desc'  => esc_html__( 'This text will be displayed when the form will successfully send', 'enginx' ),
												'value' => esc_html__( 'Message sent!', 'enginx' ),
											),
										)
									),
									'failure_message'     => array(
										'type'  => 'text',
										'label' => esc_html__( 'Failure Message', 'enginx' ),
										'desc'  => esc_html__( 'This text will be displayed when the form will fail to be sent', 'enginx' ),
										'value' => esc_html__( 'Oops something went wrong.', 'enginx' ),
									),
								),
							),
						)
					),
					'mailer-options'   => array(
						'title'   => esc_html__( 'Mailer Options', 'enginx' ),
						'type'    => 'tab',
						'options' => array(
							'mailer' => array(
								'label' => false,
								'type'  => 'mailer'
							)
						)
					)
				),
			),
		),
	)
);