<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}
/**
 * Framework options
 *
 * @var array $options Fill this array with options to generate framework settings form in WordPress customizer
 */

//theme defaults
$options_class = new Enginx_Options();
$defaults = $options_class->get_default_options_array();

// color defaults
$current_colors = enginx_get_theme_current_colors();

//find fw_ext
$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
$meta_social_icons  = array();
$header_buttons  = array();
if ( ! empty( $shortcodes_extension ) ) {
	$meta_social_icons = $shortcodes_extension->get_shortcode( 'icons_social' )->get_options();
	$header_buttons = $shortcodes_extension->get_shortcode( 'button' )->get_options();
}

$slider_extension = fw()->extensions->get( 'slider' );
$choices_blog_slider          = '';
if ( ! empty ( $slider_extension ) ) {
	$choices_blog_slider = $slider_extension->get_populated_sliders_choices();
}
//adding empty value to disable slider
$choices_blog_slider['0'] = esc_html__( 'No Slider', 'enginx' );

$options = array(
	'meta_section' => array(
		'title'   => esc_html__( 'Theme Meta', 'enginx' ),
		'options' => array(

			'meta_email' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Email', 'enginx' ),
				'desc'  => esc_html__( 'Email to appear in header', 'enginx' ),
				'help'  => esc_html__( 'Not all headers display this info', 'enginx' ),
			),
			'meta_address' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Address', 'enginx' ),
				'desc'  => esc_html__( 'Address to appear in header', 'enginx' ),
				'help'  => esc_html__( 'Not all headers display this info', 'enginx' ),
			),
			'meta_phone' => array(
				'type'  => 'text',
				'value' => '',
				'label' => esc_html__( 'Phone number', 'enginx' ),
				'desc'  => esc_html__( 'Number to appear in header', 'enginx' ),
				'help'  => esc_html__( 'Not all headers display this info', 'enginx' ),
			),
			'header_buttons'        => array(
				'label'         => esc_html__( 'Buttons', 'enginx' ),
				'popup-title'   => esc_html__( 'Add/Edit Buttons', 'enginx' ),
				'desc'          => esc_html__( 'Add button for toplogo', 'enginx' ),
				'type'          => 'addable-popup',
				'limit'         => 1, // limit the number of boxes that can be added
				'template'      => '{{=label}}',
				'popup-options' => array(
					$header_buttons,
				)
			),
			$meta_social_icons,
			'meta_image' => array(
				'label' => esc_html__( 'Login Form Image', 'enginx' ),
				'desc'  => esc_html__( 'Image that appear in login form', 'enginx' ),
				'type'  => 'upload'
			),
		),
		'wp-customizer-args' => array(
			'active_callback' => '__return_true',
		),
	),
	'header_section'       => array(
		'title'   => esc_html__( 'Theme Header Section', 'enginx' ),
		'options' => array(
			'logo_section'         => array(
				'title'   => esc_html__( 'Logo', 'enginx' ),
				'options' => array(
					'logo_image'             => array(
						'type'        => 'upload',
						'value'       => array(),
						'attr'        => array( 'class' => 'logo_image-class', 'data-logo_image' => 'logo_image' ),
						'label'       => esc_html__( 'Main logo image that appears in header', 'enginx' ),
						'desc'        => esc_html__( 'Select your logo', 'enginx' ),
						'help'        => esc_html__( 'Choose image to display as a site logo', 'enginx' ),
						'images_only' => true,
						'files_ext'   => array( 'png', 'jpg', 'jpeg', 'gif' ),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'logo_image_inverse'             => array(
						'type'        => 'upload',
						'value'       => array(),
						'attr'        => array( 'class' => 'logo_image-class', 'data-logo_image' => 'logo_image' ),
						'label'       => esc_html__( 'Main inverse logo image that appears in dark header', 'enginx' ),
						'desc'        => esc_html__( 'Select your inverse logo', 'enginx' ),
						'help'        => esc_html__( 'Choose image to display as a site inverse logo', 'enginx' ),
						'images_only' => true,
						'files_ext'   => array( 'png', 'jpg', 'jpeg', 'gif' ),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'logo_text'              => array(
						'type'  => 'text',
						'value' => 'Enginx',
						'attr'  => array( 'class' => 'logo_text-class', 'data-logo_text' => 'logo_text' ),
						'label' => esc_html__( 'Logo Text', 'enginx' ),
						'desc'  => esc_html__( 'Text that appears near logo image', 'enginx' ),
						'help'  => esc_html__( 'Type your text to show it in logo', 'enginx' ),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'logo_image_breadcrumbs' => array(
						'type'        => 'upload',
						'value'       => array(),
						'attr'        => array(
							'class'                       => 'logo_image_breadcrumbs-class',
							'data-logo_image_breadcrumbs' => 'logo_image_breadcrumbs'
						),
						'label'       => esc_html__( 'Logo image that appears in title section', 'enginx' ),
						'desc'        => esc_html__( 'Select secondary logo image that appears in title section. Not all title section has this image in it', 'enginx' ),
						'help'        => esc_html__( 'Choose image to display as a site logo', 'enginx' ),
						'images_only' => true,
						'files_ext'   => array( 'png', 'jpg', 'jpeg', 'gif' ),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
				),
			),
			enginx_get_header_options_array_for_customizer_and_page( $defaults ),
			'topline_section_options' => array(
				'title'              => esc_html__( 'Topline Section Options', 'enginx' ),
				'options'            => enginx_get_section_options_array( 'topline_', array(
					'top_padding',
					'bottom_padding',
					'top_padding_sm',
					'bottom_padding_sm',
					'top_padding_md',
					'bottom_padding_md',
					'top_padding_lg',
					'bottom_padding_lg',
					'top_padding_xl',
					'bottom_padding_xl',
					'columns_padding',
					'columns_vertical_margins',
					'is_align_vertical',

				) ),
				//show topline options only when header layout with topline chosen
				'wp-customizer-args' => array(
					'active_callback' => 'enginx_topline_is_visible',
				),
			),
			'toplogo_section_options' => array(
				'title'              => esc_html__( 'Toplogo Section Options', 'enginx' ),
				'options'            => enginx_get_section_options_array( 'toplogo_', array(
					'top_padding',
					'bottom_padding',
					'top_padding_sm',
					'bottom_padding_sm',
					'top_padding_md',
					'bottom_padding_md',
					'top_padding_lg',
					'bottom_padding_lg',
					'top_padding_xl',
					'bottom_padding_xl',
					'columns_padding',
					'columns_vertical_margins',
					'is_align_vertical',

				) ),
				'wp-customizer-args' => array(
					'active_callback' => 'enginx_toplogo_is_visible',
				),
			),
		),
	),
	'title_section'        => array(
		'title'   => esc_html__( 'Theme Title Section', 'enginx' ),
		'options' => array(
			'title_layout'          => array(
				'title'   => esc_html__( 'Title Section Layout', 'enginx' ),
				'options' => array(
					'page_title'      => array(
						'type'    => 'select',
						'value'   => $defaults['page_title'],
						'attr'    => array(
							'class'    => 'breadcrumbs-thumbnail',
						),
						'label'   => esc_html__( 'Page title sections with optional breadcrumbs', 'enginx' ),
						'desc'    => esc_html__( 'Select one of predefined page title sections. Install Unyson Breadcrumbs extension to display breadcrumbs', 'enginx' ),
						'help'    => esc_html__( 'You can select one of predefined theme title sections', 'enginx' ),
						'choices' => array(
							'1' => esc_html__( 'Default - title above breadcrumbs', 'enginx' ),
							'2' => esc_html__( 'Left title with right breadcrumbs', 'enginx' ),
							'3' => esc_html__( 'Left title with inline breadcrumbs', 'enginx' ),
							'4' => esc_html__( 'Centered title with bottom right breadcrumbs', 'enginx' ),
							'5' => esc_html__( 'Left title with left breadcrumbs', 'enginx' ),
							'6' => esc_html__( 'Centered small title with bottom small breadcrumbs', 'enginx' ),
						),
						'blank'   => false, // (optional) if true, image can be deselected
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'hide_term_title' => array(
						'type'         => 'switch',
						'value'        => true,
						'label'        => esc_html__( 'Hide Term Name', 'enginx' ),
						'desc'         => esc_html__( 'May to hide Archive or Taxonomy Name, such as \'Archives: \', \'Category: \', \'Tag: \', etc. ', 'enginx' ),
						'right-choice' => array(
							'value' => false,
							'label' => esc_html__( 'Show', 'enginx' )
						),
						'left-choice'  => array(
							'value' => true,
							'label' => esc_html__( 'Hide', 'enginx' )
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
				),
			),
			'title_section_options' => array(
				'title'   => esc_html__( 'Title Section Options', 'enginx' ),
				'options' => enginx_get_section_options_array( 'title_', array(
					'columns_padding',
					'columns_vertical_margins',
					'is_align_vertical',
				) ),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'title_section_padding' => array(
				'title'   => esc_html__( 'Title Section Padding', 'enginx' ),
				'options' => enginx_unyson_option_get_section_padding_array( 'title_'),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
		),
	),
	'footer_section'       => array(
		'title'   => esc_html__( 'Theme Footer Section', 'enginx' ),
		'options' => array(
			enginx_get_footer_options_array_for_customizer_and_page( $defaults )
		),
	),
	'copyright_section'    => array(
		'title'   => esc_html__( 'Theme Copyright Section', 'enginx' ),
		'options' => array(
			'copyright_layout'          => array(
				'title'   => esc_html__( 'Copyright Section Layout', 'enginx' ),
				'options' => array(
					'page_copyright' => array(
						'type'    => 'select',
						'value'   => $defaults['page_copyright'],
						'label'   => esc_html__( 'Page copyright', 'enginx' ),
						'desc'    => esc_html__( 'Select one of predefined page copyright sections.', 'enginx' ),
						'help'    => esc_html__( 'You can select one of predefined theme copyright section', 'enginx' ),
						'choices' => array(
							'1' => esc_html__( 'One centered column', 'enginx' ),
							'2' => esc_html__( 'Two columns', 'enginx' ),
							'3' => esc_html__( 'Three columns with logo and menu', 'enginx' ),
							'4' => esc_html__( 'Two columns with menu', 'enginx' ),
						),
						'blank'   => false, // (optional) if true, image can be deselected
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'copyright_text' => array(
						'type'  => 'textarea',
						'value' => '&copy; Enginx <span class="copyright_year">2019</span> | Created with <i class="fa fa-heart color-main"></i> by Author',
						'label' => esc_html__( 'Copyright text', 'enginx' ),
						'desc'  => esc_html__( 'Please type your copyright text', 'enginx' ),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'copyright_text2' => array(
						'type'  => 'textarea',
						'value' => 'Theme: Enginx',
						'label' => esc_html__( 'Copyright secondary text', 'enginx' ),
						'desc'  => esc_html__( 'Please type your copyright secondary text', 'enginx' ),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_copyright_secondary_text_is_visible',
						),
					),
					'copyright_logo' => array(
						'type'  => 'upload',
						'value' => '',
						'label' => esc_html__( 'Copyright logo', 'enginx' ),
						'desc'  => esc_html__( 'Appears in certain copyright layouts', 'enginx' ),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_copyright_logo_is_visible',
						),
					),
				),
			),
			'copyright_section_options' => array(
				'title'   => esc_html__( 'Copyright Section Options', 'enginx' ),
				'options' => enginx_get_section_options_array( 'copyright_' ),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'copyright_section_padding' => array(
				'title'   => esc_html__( 'Copyright Section Padding', 'enginx' ),
				'options' => enginx_unyson_option_get_section_padding_array( 'copyright_'),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
		),
	),
	'404_panel'      => array(
		'title' => esc_html__( 'Theme 404 page', 'enginx' ),
		'options' => array(
			'404_section_options' => array(
				'title'   => esc_html__( '404 Section Options', 'enginx' ),
				'options' => enginx_get_section_options_array( '404_', array(
					'columns_padding',
					'columns_vertical_margins',
					'is_align_vertical',
				) ),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'404_section_padding' => array(
				'title'   => esc_html__( '404 Section Padding', 'enginx' ),
				'options' => enginx_unyson_option_get_section_padding_array( '404_'),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
		)
	),
	'fonts_section'        => array(
		'title'   => esc_html__( 'Theme Fonts', 'enginx' ),
		'options' => array(
			'body_fonts_section' => array(
				'title'   => esc_html__( 'Font for body', 'enginx' ),
				'options' => array(
					'body_font_picker_switch' => array(
						'type'    => 'multi-picker',
						'label'   => false,
						'desc'    => false,
						'picker'  => array(
							'main_font_enabled' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => esc_html__( 'Enable', 'enginx' ),
								'desc'         => esc_html__( 'Enable custom body font', 'enginx' ),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__( 'Disabled', 'enginx' ),
								),
								'right-choice' => array(
									'value' => 'main_font_options',
									'label' => esc_html__( 'Enabled', 'enginx' ),
								),
							),
						),
						'choices' => array(
							'main_font_options' => array(
								'main_font' => array(
									'type'       => 'typography-v2',
									'value'      => array(
										'family'         => 'Roboto',
										'subset'         => 'latin-ext',
										'variation'      => 'regular',
										'size'           => 14,
										'line-height'    => 24,
										'letter-spacing' => 0,
										'color'          => '#0000ff'
									),
									'components' => array(
										'family'         => true,
										'size'           => true,
										'line-height'    => true,
										'letter-spacing' => true,
										'color'          => false
									),
									'label'      => esc_html__( 'Custom font', 'enginx' ),
									'desc'       => esc_html__( 'Select custom font for headings', 'enginx' ),
									'help'       => esc_html__( 'You should enable using custom heading fonts above at first', 'enginx' ),
								),
							),
						),
					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),

			'headings_fonts_section' => array(
				'title'   => esc_html__( 'Font for headings', 'enginx' ),
				'options' => array(
					'h_font_picker_switch' => array(
						'type'    => 'multi-picker',
						'label'   => false,
						'desc'    => false,
						'picker'  => array(
							'h_font_enabled' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => esc_html__( 'Enable', 'enginx' ),
								'desc'         => esc_html__( 'Enable custom heading font', 'enginx' ),
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__( 'Disabled', 'enginx' ),
								),
								'right-choice' => array(
									'value' => 'h_font_options',
									'label' => esc_html__( 'Enabled', 'enginx' ),
								),
							),
						),
						'choices' => array(
							'h_font_options' => array(
								'h_font' => array(
									'type'       => 'typography-v2',
									'value'      => array(
										'family'         => 'Roboto',
										'subset'         => 'latin-ext',
										'variation'      => 'regular',
										'size'           => 28,
										'line-height'    => '100%',
										'letter-spacing' => 0,
										'color'          => '#0000ff'
									),
									'components' => array(
										'family'         => true,
										'size'           => false,
										'line-height'    => false,
										'letter-spacing' => true,
										'color'          => false
									),
									'label'      => esc_html__( 'Custom font', 'enginx' ),
									'desc'       => esc_html__( 'Select custom font for headings', 'enginx' ),
									'help'       => esc_html__( 'You should enable using custom heading fonts above at first', 'enginx' ),
								),
							),
						),
					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),

		),
	),
	'theme_options_section' => array(
		'title'   => esc_html__( 'Theme Options', 'enginx' ),
		'options' => array(
			'layout_section'       => array(
				'title'   => esc_html__( 'Theme Layout', 'enginx' ),
				'options' => array(
					'layout' => array(
						'type'    => 'multi-picker',
						'value'   => 'wide',
						'attr'    => array( 'class' => 'theme-layout-class', 'data-theme-layout' => 'layout' ),
						'label'   => esc_html__( 'Theme layout', 'enginx' ),
						'desc'    => esc_html__( 'Wide or Boxed layout', 'enginx' ),
						'picker'  => array(
							'boxed' => array(
								'type'         => 'switch',
								'value'        => '',
								'label'        => false,
								'desc'         => false,
								'left-choice'  => array(
									'value' => '',
									'label' => esc_html__( 'Wide', 'enginx' ),
								),
								'right-choice' => array(
									'value' => 'boxed_options',
									'label' => esc_html__( 'Boxed', 'enginx' ),
								),
							),
						),
						'choices' => array(
							'boxed_options' => array(
								'body_background_image' => array(
									'type'        => 'upload',
									'value'       => '',
									'label'       => esc_html__( 'Body background image', 'enginx' ),
									'help'        => esc_html__( 'Choose body background image if needed.', 'enginx' ),
									'images_only' => true,
								),
								'body_cover'            => array(
									'type'         => 'switch',
									'value'        => '',
									'label'        => esc_html__( 'Parallax background', 'enginx' ),
									'desc'         => esc_html__( 'Enable full width background for body', 'enginx' ),
									'left-choice'  => array(
										'value' => '',
										'label' => esc_html__( 'No', 'enginx' ),
									),
									'right-choice' => array(
										'value' => 'yes',
										'label' => esc_html__( 'Yes', 'enginx' ),
									),
								),
								'boxed_extra_margins'            => array(
									'type'         => 'switch',
									'value'        => '',
									'label'        => esc_html__( 'Additional margins', 'enginx' ),
									'desc'         => esc_html__( 'Enable additional margins for boxed container', 'enginx' ),
									'left-choice'  => array(
										'value' => '',
										'label' => esc_html__( 'No', 'enginx' ),
									),
									'right-choice' => array(
										'value' => 'yes',
										'label' => esc_html__( 'Yes', 'enginx' ),
									),
								),
							),
						),

					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'version_section'      => array(
				'title'   => esc_html__( 'Theme Variant', 'enginx' ),
				'options' => array(
					'version' => array(
						'type'    => 'radio',
						'value'   => 'light',
						'attr'    => array( 'class' => 'theme-layout-class', 'data-theme-layout' => 'layout' ),
						'label'   => esc_html__( 'Theme Version', 'enginx' ),
						'desc'    => esc_html__( 'Light or dark version', 'enginx' ),
						'help'    => esc_html__( 'Select one of predefined versions', 'enginx' ),
						'choices' => array(
							'ls' => esc_html__( 'Light', 'enginx' ),
							'ds'  => esc_html__( 'Dark', 'enginx' ),
						),
						// Display choices inline instead of list
						'inline'  => true,
					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_false',
				),
			),
			'color_scheme_section' => array(
				'title'   => esc_html__( 'Theme Color Scheme', 'enginx' ),
				'options' => array(
					'color_scheme_number' => array(
						'type'    => 'select',
						'value'   => '',
						'label'   => esc_html__( 'Predefined Color scheme', 'enginx' ),
						'desc'    => esc_html__( 'Select one of predefined color schemes number', 'enginx' ),
						'choices' => array(
							''  => '1',
							'2' => '2',
							'3' => '3',
						),
						'blank'   => false, // (optional) if true, image can be deselected
						'wp-customizer-args' => array(
							'active_callback' => '__return_false',
						),
					),
					'accent_color_1' => array(
						'label' => esc_html__( 'Override first color scheme', 'enginx' ),
						'desc'  => esc_html__( 'Accent Color 1', 'enginx' ),
						'help'  => esc_html__( 'This colors are used for regenerate predefined "css/main.css" file with first color scheme. Remove custom color values for reset first color scheme to defaults.', 'enginx' ),
						'type'  => 'color-picker',
						'value' => $current_colors['accent_color_1'],
						'wp-customizer-setting-args' => array(
							'transport' => 'postMessage',
						),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_wp_scss_is_installed',
						),
					),
					'accent_color_2' => array(
						'label' => false,
						'desc'  => esc_html__( 'Accent Color 2', 'enginx' ),
						'type'  => 'color-picker',
						'value' => $current_colors['accent_color_2'],
						'wp-customizer-setting-args' => array(
							'transport' => 'postMessage',
						),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_wp_scss_is_installed',
						),
					),
					'accent_color_3' => array(
						'label' => false,
						'desc'  => esc_html__( 'Accent Color 3', 'enginx' ),
						'type'  => 'color-picker',
						'value' => $current_colors['accent_color_3'],
						'wp-customizer-setting-args' => array(
							'transport' => 'postMessage',
						),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_wp_scss_is_installed',
						),
					),
					'accent_color_4' => array(
						'label' => false,
						'desc'  => esc_html__( 'Accent Color 4', 'enginx' ),
						'type'  => 'color-picker',
						'value' => $current_colors['accent_color_4'],
						'wp-customizer-setting-args' => array(
							'transport' => 'postMessage',
						),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_wp_scss_is_installed',
						),
					),
					'accent_color_5' => array(
						'label' => false,
						'desc'  => esc_html__( 'Accent Color 5', 'enginx' ),
						'type'  => 'color-picker',
						'value' => $current_colors['accent_color_5'],
						'wp-customizer-setting-args' => array(
							'transport' => 'postMessage',
						),
						'wp-customizer-args' => array(
							'active_callback' => 'enginx_wp_scss_is_installed',
						),
					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'blog_section'         => array(
				'title'   => esc_html__( 'Theme Blog Options', 'enginx' ),
				'options' => array(
					'blog_layout' => array(
						'type'    => 'select',
						'value'   => '1',
						'label'   => esc_html__( 'Blog layout', 'enginx' ),
						'desc'    => esc_html__( 'Select one of predefined blog layouts', 'enginx' ),
						'choices' => array(
							'1' => '1',
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'grid' => 'Grid',
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'blog_hide_categories' => array(
						'type'  => 'switch',
						'value' => false,
						'label' => esc_html__('Hide categories in blog feed', 'enginx'),
						'left-choice' => array(
							'value' => false,
							'label' => esc_html__(' Show', 'enginx'),
						),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__(' Hide', 'enginx'),
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'blog_hide_tags' => array(
						'type'  => 'switch',
						'value' => false,
						'label' => esc_html__('Hide tags in blog feed', 'enginx'),
						'left-choice' => array(
							'value' => false,
							'label' => esc_html__(' Show', 'enginx'),
						),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__(' Hide', 'enginx'),
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'blog_hide_author' => array(
						'type'  => 'switch',
						'value' => false,
						'label' => esc_html__('Hide author in blog feed', 'enginx'),
						'left-choice' => array(
							'value' => false,
							'label' => esc_html__(' Show', 'enginx'),
						),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__(' Hide', 'enginx'),
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'blog_hide_date' => array(
						'type'  => 'switch',
						'value' => false,
						'label' => esc_html__('Hide date in blog feed', 'enginx'),
						'left-choice' => array(
							'value' => false,
							'label' => esc_html__(' Show', 'enginx'),
						),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__(' Hide', 'enginx'),
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'blog_change_date' => array(
						'type'  => 'switch',
						'value' => false,
						'label' => esc_html__('Change date to time ago', 'enginx'),
						'left-choice' => array(
							'value' => false,
							'label' => esc_html__('False', 'enginx'),
						),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__(' True', 'enginx'),
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'blog_hide_comments_link' => array(
						'type'  => 'switch',
						'value' => false,
						'label' => esc_html__('Hide comments link in blog feed', 'enginx'),
						'left-choice' => array(
							'value' => false,
							'label' => esc_html__(' Show', 'enginx'),
						),
						'right-choice' => array(
							'value' => true,
							'label' => esc_html__(' Hide', 'enginx'),
						),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
				),
				'wp-customizer-args' => array(
					'active_callback' => '__return_true',
				),
			),
			'preloader_panel'      => array(
				'title' => esc_html__( 'Theme Preloader', 'enginx' ),
				'options' => array(
					'preloader' => array(
						'type'  => 'multi-picker',
						'label' => false,
						'desc'  => false,
						'value' => array(
							'css' => 'css',
						),
						'picker' => array(
							'preloader_type' => array(
								'label'   => esc_html__('Choose preloader type', 'enginx'),
								'type'    => 'select', // or 'short-select'
								'value'   => 'css',
								'choices' => array(
									'css'  => esc_html__('Default', 'enginx'),
									'image' => esc_html__('Default Image', 'enginx'),
									'image_custom' => esc_html__('Custom Image', 'enginx'),
									'disabled' => esc_html__('Disabled', 'enginx'),
								),
								'help'    => esc_html__('You can use default CSS or Image preloader, use your own image or disable preloader', 'enginx'),
							)
						),
						'choices' => array(
							'css'  => array(
								'options' => array(
									'type'  => 'hidden',
									'value' => 'css',
								)
							),
								'image'  => array(
									'options' => array(
									'type'  => 'hidden',
									'value' => 'image',
								),
							),
								'image_custom' => array(
									'options' => array(
									'type'        => 'upload',
									'value'       => '',
									'label'       => esc_html__( 'Custom preloader image', 'enginx' ),
									'help'        => esc_html__( 'GIF image recommended. Recommended maximum preloader width 150px, maximum preloader height 150px.', 'enginx' ),
									'images_only' => true,
								),
							),
								'disabled' => array(
									'options' => array(
									'type'  => 'hidden',
									'value' => false,
								),
							),
						),
						/**
						 * (optional) if is true, the borders between choice options will be shown
						 */
						'show_borders' => false,
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					),
					'preloader_custom_class' => array(
						'type' => 'text',
						'label' => esc_html__( 'Additional CSS class', 'enginx' ),
						'wp-customizer-args' => array(
							'active_callback' => '__return_true',
						),
					)
				),
			),
			'share_buttons'   => array(
				'title' => esc_html__( 'Theme Share Buttons', 'enginx' ),

				'options' => array(
					'share_telegram'    => array(
						'type'         => 'switch',
						'value'        => '1',
						'label'        => esc_html__( 'Enable Telegram Share Button', 'enginx' ),
						'left-choice'  => array(
							'value' => '1',
							'label' => esc_html__( 'Enabled', 'enginx' ),
						),
						'right-choice' => array(
							'value' => '0',
							'label' => esc_html__( 'Disabled', 'enginx' ),
						),
					),
					'share_facebook'    => array(
						'type'         => 'switch',
						'value'        => '1',
						'label'        => esc_html__( 'Enable Facebook Share Button', 'enginx' ),
						'left-choice'  => array(
							'value' => '1',
							'label' => esc_html__( 'Enabled', 'enginx' ),
						),
						'right-choice' => array(
							'value' => '0',
							'label' => esc_html__( 'Disabled', 'enginx' ),
						),
					),
					'share_twitter'     => array(
						'type'         => 'switch',
						'value'        => '1',
						'label'        => esc_html__( 'Enable Twitter Share Button', 'enginx' ),
						'left-choice'  => array(
							'value' => '1',
							'label' => esc_html__( 'Enabled', 'enginx' ),
						),
						'right-choice' => array(
							'value' => '0',
							'label' => esc_html__( 'Disabled', 'enginx' ),
						),
					),
					'share_pinterest'   => array(
						'type'         => 'switch',
						'value'        => '1',
						'label'        => esc_html__( 'Enable Pinterest Share Button', 'enginx' ),
						'left-choice'  => array(
							'value' => '1',
							'label' => esc_html__( 'Enabled', 'enginx' ),
						),
						'right-choice' => array(
							'value' => '0',
							'label' => esc_html__( 'Disabled', 'enginx' ),
						),
					),
					'share_linkedin'    => array(
						'type'         => 'switch',
						'value'        => '1',
						'label'        => esc_html__( 'Enable LinkedIn Share Button', 'enginx' ),
						'left-choice'  => array(
							'value' => '1',
							'label' => esc_html__( 'Enabled', 'enginx' ),
						),
						'right-choice' => array(
							'value' => '0',
							'label' => esc_html__( 'Disabled', 'enginx' ),
						),
					),

				),
				'wp-customizer-args' => array(
					'active_callback' => 'enginx_shared_buttons_options_is_visible',
				),
			),
		),
	),
);