<?php
/**
 * The template part for selected copyrights section
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$options = enginx_get_options();
$section = enginx_get_section_options( $options, 'copyright_' );
?>
<section class="page_copyright <?php echo esc_attr( $section['section_class'] ); ?>"
	<?php echo ( !empty( $section['section_id'] ) ) ? 'id="'. esc_attr( $section['section_id'] ) . '"' : ''; ?>
	<?php echo ( !empty( $section['section_background_image'] ) ) ? 'style="'. esc_attr( $section['section_background_image'] ) . '"' : ''; ?>
>
	<div class="particles-js" id="<?php echo esc_attr( uniqid('par-') ); ?>"></div>
	<div class="container<?php echo esc_attr( $section['section_container_class_suffix'] ); ?>">
		<?php if( is_active_sidebar( 'sidebar-copyright-top-fullwidth' ) ) : ?>
			<?php
			dynamic_sidebar( 'sidebar-copyright-top-fullwidth' );
			?>
		<?php
		endif; //sidebar-copyright-top-fullwidth ?>
		<div class="row align-items-center">
			<div class="col-sm-12 text-center">
				<?php echo ( ! empty ( $options['copyright_text'] ) )
					? wp_kses_post( $options['copyright_text'] )
					: esc_html__( 'Powered by WordPress', 'enginx' ) . ' &copy; ' . date('Y' ); ?>
			</div>
		</div>
	</div>
</section><!-- .page_copyright -->