<?php
/**
 * The template part for selected header
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$options = enginx_get_options();
$section = enginx_get_section_options( $options, 'toplogo_' );

//toplogo section with contact and search button
?>
<section class="page_toplogo overflow-visible c-my-10 <?php echo esc_attr( $section['section_class'] ); ?>"
	<?php echo ( !empty( $section['section_id'] ) ) ? 'id="'. esc_attr( $section['section_id'] ) . '"' : ''; ?>
	<?php echo ( !empty( $section['section_background_image'] ) ) ? 'style="'. esc_attr( $section['section_background_image'] ) . '"' : ''; ?>
>
	<div class="particles-js" id="<?php echo esc_attr( uniqid('par-') ); ?>"></div>
	<div class="container<?php echo esc_attr( $section['section_container_class_suffix'] ); ?>">

		<div class="row align-items-center">
			<div class="col-lg-4">
				<?php if ( ! empty ( $options['meta_phone'] ) ) : ?>
				<h4 class="mb-0">
					<?php echo esc_html( $options['meta_phone'] ); ?>
				</h4>
				<?php endif; ?>
				<?php if ( ! empty ( $options['meta_email'] ) ) : ?>
				<p>
					<a href="mailto:<?php echo esc_attr( $options['meta_email'] ); ?>">
						<?php echo esc_html( $options['meta_email'] ); ?>
					</a>
				</p>
				<?php endif; ?>
			</div>

			<div class="col-lg-4 text-center">
				<?php get_template_part( 'template-parts/logo/header-logo' ); ?>
			</div>

			<div class="col-lg-4">

				<div class="d-lg-flex justify-content-lg-end align-items-lg-center">
					<ul class="top-includes">
					<?php if ( $options['woo'] ) : ?>
						<li class="cart-dropdown">
							<div class="dropdown shop-card-dropdown">
								<a class="dropdown-toggle dropdown-shopping-cart" href="#" role="button" id="dropdown-cart" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<?php
									echo '<span class="badge bg-maincolor cart-count">';
									if (  WC()->cart->get_cart_contents_count() !== 0 ) {
										echo esc_html( WC()->cart->get_cart_contents_count() );
									}
									echo '</span>';
									?>
									<i class="ico-shopping-bag"></i>
								</a>
								<div class="dropdown-menu dropdown-menu-right ls" aria-labelledby="dropdown-cart">
									<?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>
								</div>
							</div>
						</li><!-- eof woo cart -->
					<?php endif; //woocommerce ?>
					<?php
					if ( !empty ( $options['social_icons'] ) && !empty ( $options['fw'] ) ) :
						?>
						<li class="social-icons">
						<?php
							//get icons-social shortcode to render icons in team member item
							$shortcodes_extension = fw()->extensions->get( 'shortcodes' );
							if ( ! empty( $shortcodes_extension ) ) :
								echo fw_ext( 'shortcodes' )->get_shortcode( 'icons_social' )->render( array( 'social_icons' => $options['social_icons'] ) );
							endif; //
						?>
						</li>
					<?php endif; //social_icons ?>
					</ul>
				</div>
			</div>

		</div>
	</div>
</section><!-- .page_toplogo -->
